/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.node.Heading;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.node.Text;

public class MdParserUtils {
    public static final Function<Node, String> SIMPLE_EXTRACTOR = textNode -> {
        if (textNode instanceof Text) {
            return ((Text)textNode).getLiteral();
        }
        if (textNode instanceof Link) {
            return ((Link)textNode).getDestination();
        }
        return null;
    };
    public static final Function<Node, String> LOWERCASE_EXTRACTOR = textNode -> {
        if (textNode instanceof Text) {
            return ((Text)textNode).getLiteral().toLowerCase();
        }
        if (textNode instanceof Link) {
            return ((Link)textNode).getDestination().toLowerCase();
        }
        return null;
    };

    public static Node findHeading(Node node, int level, String titleToFind) {
        return MdParserUtils.findHeading(node, level, titleToFind, SIMPLE_EXTRACTOR);
    }

    public static Node findHeading(Node node, int level, String titleToFind, Function<Node, String> titleExtractor) {
        while (node != null) {
            Node textNode;
            Heading heading;
            if (node instanceof Heading && (heading = (Heading)node).getLevel() == level && titleToFind.equals(titleExtractor.apply(textNode = heading.getFirstChild()))) {
                return node;
            }
            node = node.getNext();
        }
        return null;
    }

    public static <T> List<T> collectSiblings(Node firstSibling, Class<T> clazz) {
        ArrayList<T> siblings = new ArrayList<T>();
        Node siblingPointer = firstSibling;
        while (clazz.isInstance(siblingPointer)) {
            siblings.add(clazz.cast(siblingPointer));
            siblingPointer = siblingPointer.getNext();
        }
        return siblings;
    }

    public static List<Node> collectSiblings(Node firstSibling) {
        return MdParserUtils.collectSiblings(firstSibling, Node.class);
    }

    public static List<Paragraph> collectParagraphs(Node firstParagraph) {
        return MdParserUtils.collectSiblings(firstParagraph, Paragraph.class);
    }

    public static List<TableCell> collectCells(Node firstCell) {
        return MdParserUtils.collectSiblings(firstCell, TableCell.class);
    }

    public static List<TableRow> collectRows(Node firstRow) {
        return MdParserUtils.collectSiblings(firstRow, TableRow.class);
    }

    public static TableHead findTableHead(Node previous) {
        for (Node node = previous.getNext(); node != null; node = node.getNext()) {
            if (!(node instanceof TableBlock)) continue;
            TableBlock tableBlock = (TableBlock)node;
            return (TableHead)tableBlock.getFirstChild();
        }
        return null;
    }

    public static TableBody findTableBody(Node previous) {
        for (Node node = previous.getNext(); node != null; node = node.getNext()) {
            if (node instanceof TableBody) {
                return (TableBody)node;
            }
            if (!(node instanceof TableBlock)) continue;
            TableBlock tableBlock = (TableBlock)node;
            return (TableBody)tableBlock.getLastChild();
        }
        return null;
    }

    public static Integer findColumnIdxByText(List<TableCell> rowCells, String ... anyOf) {
        Set<String> find = Set.of(anyOf);
        for (int idx = 0; idx < rowCells.size(); ++idx) {
            TableCell cell = rowCells.get(idx);
            Node firstChild = cell.getFirstChild();
            if (!(firstChild instanceof Text) || !find.contains(((Text)firstChild).getLiteral())) continue;
            return idx;
        }
        return null;
    }
}

