/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor;

import com.google.inject.name.Named;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphDumpSupport;
import org.qubership.itool.modules.processor.DumpAndMetainfo;
import org.qubership.itool.modules.processor.GraphMetaInfoSupport;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.processor.MergerApi;
import org.qubership.itool.modules.processor.matchers.CompoundVertexMatcher;
import org.qubership.itool.modules.processor.matchers.VertexMatcher;
import org.qubership.itool.modules.processor.tasks.CreateAppVertexTask;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.qubership.itool.modules.processor.tasks.PatchAppVertexTask;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.utils.FutureUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMerger
implements MergerApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphMerger.class);
    private boolean failFast = false;
    protected Vertx vertx;
    protected boolean ownVertx;
    private boolean useDeepCopy;
    private final Provider<Graph> graphProvider;
    private final Provider<List<GraphProcessorTask>> normalizationTasks;
    private final Provider<List<GraphProcessorTask>> finalizationTasks;
    private final Function<JsonObject, CreateAppVertexTask> createAppVertexTaskFactory;
    private final Function<JsonObject, PatchAppVertexTask> patchAppVertexTaskFactory;
    private final Provider<CompoundVertexMatcher> compoundMatcherProvider;

    @Inject
    public GraphMerger(Vertx vertx, Provider<Graph> graphProvider, @Named(value="normalization.tasks") Provider<List<GraphProcessorTask>> normalizationTasks, @Named(value="finalization.tasks") Provider<List<GraphProcessorTask>> finalizationTasks, Function<JsonObject, CreateAppVertexTask> createAppVertexTaskFactory, Function<JsonObject, PatchAppVertexTask> patchAppVertexTaskFactory, Provider<CompoundVertexMatcher> compoundMatcherProvider) {
        if (vertx == null) {
            this.vertx = Vertx.vertx();
            this.ownVertx = true;
        } else {
            this.vertx = vertx;
            this.ownVertx = false;
        }
        this.graphProvider = graphProvider;
        this.normalizationTasks = normalizationTasks;
        this.finalizationTasks = finalizationTasks;
        this.createAppVertexTaskFactory = createAppVertexTaskFactory;
        this.patchAppVertexTaskFactory = patchAppVertexTaskFactory;
        this.compoundMatcherProvider = compoundMatcherProvider;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.ownVertx && this.vertx != null) {
            this.vertx.close();
        }
        this.vertx = null;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Override
    public JsonObject mergeComponentDumps(Path sourceDirectory, JsonObject targetDesc) throws IOException, InvalidGraphException {
        Graph graph = (Graph)this.graphProvider.get();
        this.prepareGraphForMerging(graph, targetDesc);
        this.walkAndMerge(sourceDirectory, graph, targetDesc);
        this.finalizeGraphAfterMerging(graph, targetDesc);
        return GraphDumpSupport.dumpToJson(graph, this.useDeepCopy);
    }

    @Override
    public JsonObject mergeDumps(List<DumpAndMetainfo> sourceDumps, JsonObject targetDesc) throws InvalidGraphException {
        Graph graph = (Graph)this.graphProvider.get();
        this.prepareGraphForMerging(graph, targetDesc);
        for (DumpAndMetainfo source : sourceDumps) {
            if (source == null) {
                throw new InvalidGraphException(graph, "null passed to mergeDumps()");
            }
            JsonObject sourceDesc = source.meta != null ? source.meta : new JsonObject();
            this.mergeDump(source.dump, sourceDesc, graph, targetDesc);
        }
        this.finalizeGraphAfterMerging(graph, targetDesc);
        return GraphDumpSupport.dumpToJson(graph, this.useDeepCopy);
    }

    @Override
    public void prepareGraphForMerging(Graph targetGraph, JsonObject targetDesc) {
        GraphMetaInfoSupport.initMetaInfoFromDesc(targetGraph, targetDesc);
    }

    @Override
    public void finalizeGraphAfterMerging(Graph targetGraph, JsonObject targetDesc) {
        Future theJob = Future.succeededFuture();
        theJob.compose(this.createAppVertexTaskFactory.apply(targetDesc).thenProcessAsync(this.vertx, targetGraph));
        for (GraphProcessorTask task : (List)this.finalizationTasks.get()) {
            theJob = theJob.compose(task.thenProcessAsync(this.vertx, targetGraph));
        }
        FutureUtils.blockForResultOrException(theJob);
        targetGraph.setGraphVersion(3);
    }

    @Override
    public void walkAndMerge(Path inputDirectory, Graph targetGraph, JsonObject targetDesc) throws IOException {
        this.getLogger().info("Merging everything from directory {}", (Object)inputDirectory);
        ArrayList sourceFiles = new ArrayList();
        try (Stream<Path> walk = Files.walk(inputDirectory, new FileVisitOption[0]);){
            walk.filter(p -> this.isAcceptableFile((Path)p)).forEach(p -> sourceFiles.add(p));
        }
        catch (IOException e) {
            JsonObject sourceDesc = new JsonObject().put("fileName", (Object)inputDirectory.toString());
            this.excHappenned(e, inputDirectory.toString(), sourceDesc, targetGraph);
        }
        for (Path path : sourceFiles) {
            JsonObject dumpFile;
            String pathString = path.toString();
            JsonObject sourceDesc = new JsonObject().put("fileName", (Object)pathString);
            try {
                dumpFile = JsonUtils.readJsonFile(pathString);
            }
            catch (IOException e) {
                this.excHappenned(e, path.toString(), sourceDesc, targetGraph);
                continue;
            }
            this.getLogger().info("Merging source graph from {}", (Object)pathString);
            this.mergeDump(dumpFile, sourceDesc, targetGraph, targetDesc);
        }
    }

    @Override
    public void mergeDump(JsonObject dump, JsonObject sourceDesc, Graph targetGraph, JsonObject targetDesc) {
        Graph sourceGraph = (Graph)this.graphProvider.get();
        try {
            GraphDumpSupport.restoreFromJson(sourceGraph, dump);
            Objects.requireNonNull(sourceGraph);
        }
        catch (NullPointerException e) {
            this.excHappenned(e, InvalidGraphException.descToName(sourceDesc), sourceDesc, targetGraph);
            return;
        }
        this.normalizeGraph(targetGraph);
        this.mergeGraph(sourceGraph, sourceDesc, targetGraph, targetDesc, this.useDeepCopy);
    }

    @Override
    public void mergeGraph(Graph sourceGraph, JsonObject sourceDesc, Graph targetGraph, JsonObject targetDesc, boolean deepCopy) {
        block4: {
            GraphMetaInfoSupport.enrichGraphDesc(sourceGraph, sourceDesc);
            this.normalizeGraph(sourceGraph);
            GraphReport sourceReport = sourceGraph.getReport();
            GraphReport targetReport = targetGraph.getReport();
            try {
                this.mergeGraphData(sourceGraph, sourceDesc, targetGraph, targetDesc, targetReport, deepCopy);
                if (targetReport != null && sourceReport != null) {
                    this.mergeReport(sourceReport, targetReport, deepCopy);
                }
            }
            catch (InvalidGraphException e) {
                this.getLogger().error("Invalid source graph: {}", (Object)e.getMessage());
                GraphMetaInfoSupport.addDroppedItem(e, sourceDesc, targetGraph);
                if (targetReport != null) {
                    targetReport.mergingError(sourceDesc, e);
                }
                if (!this.failFast) break block4;
                throw e;
            }
        }
    }

    protected void normalizeGraph(Graph graph) {
        Future theJob = Future.succeededFuture();
        for (GraphProcessorTask task : (List)this.normalizationTasks.get()) {
            theJob = theJob.compose(task.thenProcessAsync(this.vertx, graph));
        }
        FutureUtils.blockForResultOrException(theJob);
    }

    protected boolean isAcceptableFile(Path path) {
        String fileName = path.getFileName().toString();
        return (fileName.endsWith(".json") || fileName.endsWith(".json.gz")) && Files.isRegularFile(path, new LinkOption[0]);
    }

    protected void mergeGraphData(Graph sourceGraph, JsonObject sourceDesc, Graph targetGraph, JsonObject targetDesc, GraphReport targetReport, boolean deepCopy) {
        this.validateNoNullVertices(sourceGraph, sourceDesc, targetDesc, targetReport);
        this.validateInputApplication(sourceGraph, sourceDesc, targetDesc, targetReport);
        JsonObject sourceRoot = sourceGraph.getVertex("root");
        JsonObject targetRoot = targetGraph.getVertex("root");
        GraphMetaInfoSupport.mergeAssemblyInfo(sourceRoot, sourceDesc, targetRoot, targetDesc);
        VertexMatcher matcher = this.createMatcher(sourceGraph, targetGraph);
        HashMap<String, String> remapNewVertices = new HashMap<String, String>();
        for (JsonObject vertex : sourceGraph.vertexList()) {
            String newId = vertex.getString("id");
            String existingId = this.mergeVertex(sourceGraph, vertex, targetGraph, targetReport, matcher, deepCopy);
            if (existingId == null || existingId.equals(newId)) continue;
            remapNewVertices.put(newId, existingId);
        }
        List<JsonObject> edgeList = sourceGraph.edgeList();
        for (JsonObject edge : edgeList) {
            this.mergeEdge(sourceGraph, edge, targetGraph, targetReport, remapNewVertices, deepCopy);
        }
    }

    protected VertexMatcher createMatcher(Graph sourceGraph, Graph targetGraph) {
        return (VertexMatcher)this.compoundMatcherProvider.get();
    }

    protected void mergeReport(GraphReport sourceReport, GraphReport targetReport, boolean deepCopy) {
        JsonArray errors = sourceReport.dumpRecords(deepCopy);
        if (errors != null && !errors.isEmpty()) {
            for (Object error : errors) {
                targetReport.addRecord((JsonObject)error);
            }
        }
    }

    protected String mergeVertex(Graph sourceGraph, JsonObject newVertex, Graph targetGraph, GraphReport targetReport, VertexMatcher matcher, boolean deepCopy) {
        String newVertexId = newVertex.getString("id");
        JsonObject existingVertex = matcher.findExistingVertex(sourceGraph, newVertex, targetGraph);
        boolean newIsMock = this.isMockVertex(newVertex);
        if (existingVertex == null) {
            this.getLogger().debug("Adding new vertex: '{}' (isMock: {})", (Object)newVertexId, (Object)newIsMock);
            targetGraph.addVertex(deepCopy ? newVertex.copy() : newVertex);
            return null;
        }
        String existingId = existingVertex.getString("id");
        boolean existingIsMock = this.isMockVertex(existingVertex);
        this.getLogger().debug("Existing vertex '{}' (isMock: {}) matches new vertex '{}' (isMock: {})", new Object[]{existingId, existingIsMock, newVertexId, newIsMock});
        if (existingIsMock && !newIsMock) {
            this.getLogger().debug("Overwriting existing mock vertex '{}' with data from new non-mock '{}'", (Object)existingId, (Object)newVertexId);
            if (!existingId.equals(newVertexId)) {
                targetGraph.relocateVertex(existingVertex, newVertexId);
                existingId = newVertexId;
            }
            Map map = existingVertex.getMap();
            map.clear();
            map.put("id", existingId);
            Map src = deepCopy ? newVertex.copy().getMap() : newVertex.getMap();
            map.putAll(src);
            map.put("id", existingId);
        } else if (existingIsMock == newIsMock && this.conflictingVertices(newVertex, existingVertex)) {
            this.getLogger().error("Old vertex '{}' and new vertex '{}' (mock={} for both) conflict", new Object[]{existingId, newVertexId, newIsMock});
            if (targetReport != null) {
                targetReport.componentDuplicated(existingVertex, newVertex);
            }
            existingId = this.resolveConflict(newVertex, existingVertex, targetGraph, deepCopy);
        } else {
            this.getLogger().debug("Skipping new vertex '{}'", (Object)newVertexId);
        }
        return existingId;
    }

    protected boolean isMockVertex(JsonObject vertex) {
        Boolean isMock = vertex.getBoolean("isMock");
        return BooleanUtils.isTrue((Boolean)isMock);
    }

    protected boolean conflictingVertices(JsonObject newVertex, JsonObject existingVertex) {
        String newRepo;
        String newType;
        String oldType = existingVertex.getString("type");
        if (!Objects.equals(oldType, newType = newVertex.getString("type"))) {
            return true;
        }
        String oldRepo = existingVertex.getString("repository");
        return !Objects.equals(oldRepo, newRepo = newVertex.getString("repository"));
    }

    protected String resolveConflict(JsonObject newVertex, JsonObject conflict, Graph targetGraph, boolean deepCopy) {
        String conflictId = conflict.getString("id");
        String newType = newVertex.getString("type");
        String newRepo = newVertex.getString("repository");
        JsonObject candidate = (JsonObject)targetGraph.traversal().V(new String[0]).hasType(newType).has("repository", newRepo).next();
        if (candidate != null) {
            String candidateId = candidate.getString("id");
            this.getLogger().info("Conflict resolved: mapped '{}' (conflicts with '{}') -> existing vertex '{}'", new Object[]{newVertex.getString("id"), conflictId, candidateId});
            return candidateId;
        }
        String generatedId = newVertex.getString("id") + "-" + String.valueOf(UUID.randomUUID());
        candidate = new JsonObject();
        candidate.put("id", (Object)generatedId);
        Map src = deepCopy ? newVertex.copy().getMap() : newVertex.getMap();
        candidate.getMap().putAll(src);
        candidate.put("id", (Object)generatedId);
        targetGraph.addVertex(candidate);
        this.getLogger().info("Conflict resolved: mapped '{}' (conflicts with '{}') -> new vertex '{}'", new Object[]{newVertex.getString("id"), conflictId, generatedId});
        return generatedId;
    }

    protected void mergeEdge(Graph srcGraph, JsonObject edgeValue, Graph targetGraph, GraphReport targetReport, Map<String, String> remapNewVertices, boolean deepCopy) {
        String edgeId = edgeValue.getString("id");
        String baseFromId = srcGraph.getEdgeSource(edgeId).getString("id");
        String newFromId = remapNewVertices.getOrDefault(baseFromId, baseFromId);
        JsonObject sourceVertex = targetGraph.getVertex(newFromId);
        String baseToId = srcGraph.getEdgeTarget(edgeId).getString("id");
        String newToId = remapNewVertices.getOrDefault(baseToId, baseToId);
        JsonObject targetVertex = targetGraph.getVertex(newToId);
        JsonObject newEdge = deepCopy ? edgeValue.copy() : edgeValue;
        newEdge.remove("id");
        String newEdgeId = targetGraph.addEdge(sourceVertex, targetVertex, newEdge);
        if (newEdgeId != null) {
            this.getLogger().debug("Adding edge : was=('{}':'{}'->'{}'), now=('{}':'{}'->'{}')", new Object[]{edgeId, baseFromId, baseToId, newEdgeId, newFromId, newToId});
        } else {
            this.getLogger().debug("Skipping edge : was=('{}':'{}'->'{}'), now=('{}'->'{}')", new Object[]{edgeId, baseFromId, baseToId, newFromId, newToId});
        }
    }

    protected void validateNoNullVertices(Graph sourceGraph, JsonObject sourceDesc, JsonObject targetDesc, GraphReport report) {
        JsonObject nullVertex = (JsonObject)sourceGraph.traversal().V("null").next();
        if (nullVertex != null) {
            throw new InvalidGraphException(sourceDesc, "Contains null vertex");
        }
        List nullRepoVertices = sourceGraph.traversal().V(new String[0]).hasType("domain").out(new String[0]).has("repository", "null").toList();
        for (JsonObject comp : nullRepoVertices) {
            this.getLogger().error("Component {} has \"null\" repository", (Object)comp.getString("id"));
            if (report == null) continue;
            report.mandatoryValueMissed(comp, "repository");
        }
    }

    protected void validateInputApplication(Graph sourceGraph, JsonObject sourceDesc, JsonObject targetDesc, GraphReport report) {
        List existingApps = sourceGraph.traversal().V(new String[0]).hasType("application").toList();
        for (JsonObject existingApp : existingApps) {
            String appId = existingApp.getString("id");
            JsonObject someComponent = (JsonObject)sourceGraph.traversal().V(appId).out(new String[0]).next();
            if (someComponent != null) continue;
            report.mergingError(sourceDesc, "Application without any component: " + appId);
        }
        if (!sourceDesc.getBoolean("isApplication", Boolean.valueOf(false)).booleanValue()) {
            if (sourceDesc.getBoolean("isNameSpace", Boolean.valueOf(false)).booleanValue() || existingApps.isEmpty()) {
                this.getLogger().debug("Source is not an application: {}", (Object)sourceDesc);
            } else if (report != null) {
                String appNames = existingApps.stream().map(app -> app.getString("name")).collect(Collectors.joining(", ", "[", "]"));
                report.mergingError(sourceDesc, "Component graph contains some application vertices: " + appNames);
            }
            return;
        }
        if (existingApps.isEmpty()) {
            this.getLogger().warn("Patching the INPUT graph {} that contained no app vertex", (Object)sourceDesc);
            this.createAppVertexTaskFactory.apply(sourceDesc).process(sourceGraph);
            if (report != null) {
                report.mergingError(sourceDesc, "Source application graph contained no application vertex. Patched.");
            }
            return;
        }
        this.patchAppVertexTaskFactory.apply(sourceDesc).process(sourceGraph);
    }

    protected <X extends Exception> void excHappenned(X e, String sourceId, JsonObject sourceDesc, Graph targetGraph) throws X {
        this.getLogger().error("Exception when processing " + sourceId, e);
        InvalidGraphException e1 = new InvalidGraphException(sourceDesc, e.getMessage());
        GraphMetaInfoSupport.addDroppedItem(e1, sourceDesc, targetGraph);
        GraphReport targetReport = targetGraph.getReport();
        if (targetReport != null) {
            targetReport.mergingError(sourceDesc, e1);
        }
        if (this.failFast) {
            throw e;
        }
    }

    public void setUseDeepCopy(boolean useDeepCopy) {
        this.useDeepCopy = useDeepCopy;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

