/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor;

import io.vertx.core.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.graph.Graph;

public class InvalidGraphException
extends IllegalArgumentException {
    private final String reason;

    public InvalidGraphException(JsonObject graphDesc, String reason) {
        super("Graph " + InvalidGraphException.descToName(graphDesc) + " is invalid: " + reason);
        this.reason = reason;
    }

    public InvalidGraphException(Graph graph, String reason) {
        super("Graph " + InvalidGraphException.graphToName(graph) + " is invalid: " + reason);
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public static String descToName(JsonObject metaInfo) {
        if (metaInfo.getBoolean("isApplication", Boolean.valueOf(false)).booleanValue()) {
            String appVersion = metaInfo.getString("appVersion");
            if (StringUtils.isEmpty((CharSequence)appVersion)) {
                appVersion = "unknown";
            }
            return "APPLICATION:" + metaInfo.getString("appName") + ":" + appVersion;
        }
        String fileName = metaInfo.getString("fileName");
        if (fileName != null) {
            return fileName;
        }
        return "unknown";
    }

    public static String graphToName(Graph graph) {
        JsonObject meta;
        JsonObject root = graph.getVertex("root");
        if (root != null && (meta = root.getJsonObject("meta")) != null) {
            return meta.toString();
        }
        return "<unidentified graph>";
    }
}

