/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.matchers;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.processor.matchers.MockFieldExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMockFieldExtractor
implements MockFieldExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMockFieldExtractor.class);

    @Override
    public Set<String> getMockedForSet(Graph origin, JsonObject mock) {
        Object mockedFor = mock.getValue("mockedFor");
        if (mockedFor instanceof JsonArray) {
            return new HashSet<String>(((JsonArray)mockedFor).getList());
        }
        if (mockedFor instanceof String) {
            return Collections.singleton((String)mockedFor);
        }
        LOG.error("Vertex " + mock.getString("id") + " contains improper value for mockedFor");
        return Collections.emptySet();
    }
}

