/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.qubership.itool.modules.report.GraphReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchAppVertexTask
implements GraphProcessorTask {
    private static final Logger LOG = LoggerFactory.getLogger(PatchAppVertexTask.class);
    protected final JsonObject desc;
    protected final String appName;
    protected final String appVersion;
    protected boolean disabled;

    public PatchAppVertexTask(JsonObject desc) {
        this.desc = desc;
        this.appName = desc.getString("appName");
        this.appVersion = desc.getString("appVersion");
        if (!desc.getBoolean("isApplication", Boolean.valueOf(false)).booleanValue() || StringUtils.isEmpty((CharSequence)this.appVersion) || "unknown".equals(this.appVersion) || StringUtils.isEmpty((CharSequence)this.appName)) {
            this.disabled = true;
        }
    }

    @Override
    public void process(Graph graph) throws InvalidGraphException {
        GraphReport report;
        if (this.disabled) {
            LOG.info("Skipping task");
            return;
        }
        long startTime = System.nanoTime();
        LOG.info("Starting task {}", (Object)this.getClass().getSimpleName());
        List existingApps = graph.traversal().V(new String[0]).hasType("application").toList();
        boolean requiredAppFound = false;
        ArrayList<String> otherAppNames = new ArrayList<String>();
        String appVertexId = String.join((CharSequence)":", "application", this.appName, this.appVersion);
        for (JsonObject existingApp : existingApps) {
            String existingAppId = existingApp.getString("id");
            String existingAppName = existingApp.getString("name");
            if (this.appName.equals(existingAppName)) {
                requiredAppFound = true;
                String version = existingApp.getString("version");
                if (this.appVersion.equals(version)) {
                    LOG.info("Source graph contains app '{}'", (Object)existingAppId);
                    continue;
                }
                LOG.warn("Source graph contains app '{}', needed version is '{}'. Patching it.", (Object)existingAppId, (Object)this.appVersion);
                JsonObject originalApp = existingApp.copy();
                originalApp.put("version", (Object)this.appVersion);
                graph.relocateVertex(originalApp, appVertexId);
                continue;
            }
            LOG.warn("Source graph contains app with name other than '{}': '{}'", (Object)this.appName, (Object)existingAppId);
            otherAppNames.add(existingAppName);
        }
        if (!requiredAppFound && (report = graph.getReport()) != null) {
            JsonObject info = new JsonObject();
            info.put("id", (Object)appVertexId);
            report.mergingError(this.desc, "Application name '" + this.appName + "' expected, found: " + ((Object)otherAppNames).toString());
        }
        long endTime = System.nanoTime();
        LOG.info("Task completed {} in {}", (Object)this.getClass().getSimpleName(), (Object)Duration.ofNanos(endTime - startTime));
    }
}

