/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import io.vertx.core.json.JsonObject;
import java.util.List;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchMockedComponentsNormalizationTask
implements GraphProcessorTask {
    private static final Logger LOG = LoggerFactory.getLogger(PatchMockedComponentsNormalizationTask.class);

    @Override
    public void process(Graph graph) throws InvalidGraphException {
        List mockComponents = graph.traversal().V("root").out(new String[0]).hasType("application", "domain").out(new String[0]).has("isMock", P.eq(true)).dedup().toList();
        if (LOG.isDebugEnabled() && mockComponents.size() > 0) {
            LOG.debug("Found {} mock components, checking if any of them are real components", (Object)mockComponents.size());
        }
        for (JsonObject component : mockComponents) {
            if (!this.isNotMockComponent(component)) continue;
            component.put("isMock", (Object)false);
            LOG.info("Corrected the mock flag for component with name {}", (Object)component.getString("name"));
        }
    }

    private boolean isNotMockComponent(JsonObject component) {
        return component.getString("repository") != null && !"null".equalsIgnoreCase(component.getString("repository"));
    }
}

