/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.List;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchVertexDnsNamesNormalizationTask
implements GraphProcessorTask {
    private static final Logger LOG = LoggerFactory.getLogger(PatchVertexDnsNamesNormalizationTask.class);

    @Override
    public void process(Graph graph) throws InvalidGraphException {
        if (graph.getGraphVersion() >= 2) {
            LOG.debug("Skipping task {}, because graph with version {} should support multiple DNS names", (Object)this.getClass().getSimpleName(), (Object)graph.getGraphVersion());
            return;
        }
        long startTime = System.nanoTime();
        LOG.debug("Starting task {}", (Object)this.getClass().getSimpleName());
        List existingComponents = graph.traversal().V(new String[0]).hasKey("/details/dnsName").toList();
        for (JsonObject component : existingComponents) {
            JsonObject details;
            if (Boolean.TRUE.equals(component.getValue("isMock"))) {
                JsonArray mockedFor = component.getJsonArray("mockedFor");
                if (!mockedFor.contains((Object)"/details/dnsName")) continue;
                mockedFor.remove((Object)"/details/dnsName");
                mockedFor.add((Object)"/details/dnsNames");
                JsonObject details2 = component.getJsonObject("details");
                String dnsName = details2.getString("dnsName");
                details2.put("dnsNames", (Object)dnsName);
            }
            if ((details = component.getJsonObject("details")).containsKey("dnsNames")) continue;
            details.put("dnsNames", (Object)new JsonArray().add((Object)details.getString("dnsName")));
        }
        long endTime = System.nanoTime();
        LOG.debug("Task completed in {} ", (Object)Duration.ofNanos(endTime - startTime));
    }
}

