/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.query;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.util.Properties;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.GremlinException;
import org.qubership.itool.modules.query.converter.ResultConverter;
import org.qubership.itool.modules.query.converter.ToTextConverter;

public class QueryExecutor {
    private GroovyShell shell;
    private ResultConverter<?> converter = new ToTextConverter();
    private Properties converterProps;

    public QueryExecutor(BasicGraph graph) {
        Binding binding = new Binding();
        binding.setProperty("traversal", (Object)graph.traversal());
        this.shell = new GroovyShell(binding);
        this.converterProps = new Properties();
        this.converterProps.put("view.json", "compact");
        this.converterProps.put("view.map", "compact");
        this.converterProps.put("result.limit", (Object)-1);
    }

    public void setConverter(ResultConverter<?> converter) {
        this.converter = converter;
    }

    public Object executeGremlinQuery(String query) throws GremlinException {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("import io.vertx.core.json.JsonObject;\n");
            builder.append("import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;\n");
            builder.append("import org.qubership.itool.modules.gremlin2.Path;\n");
            builder.append("import org.qubership.itool.modules.gremlin2.structure.Direction\n");
            builder.append("import org.qubership.itool.modules.gremlin2.P;\n");
            builder.append("import org.qubership.itool.modules.gremlin2.graph.__\n");
            builder.append("import org.qubership.itool.modules.gremlin2.util.Order\n");
            builder.append("import static org.qubership.itool.modules.gremlin2.P.*;\n");
            builder.append("import static org.qubership.itool.modules.gremlin2.graph.__.*;\n");
            builder.append("import static org.qubership.itool.modules.gremlin2.util.Order.*;\n");
            builder.append("import static org.qubership.itool.modules.gremlin2.structure.MapElement.*;\n");
            builder.append("import static org.qubership.itool.modules.gremlin2.util.StringSplitter.*;\n");
            builder.append("\n");
            builder.append("result = traversal").append(query);
            this.shell.evaluate(builder.toString());
            return this.shell.getProperty("result");
        }
        catch (GroovyRuntimeException e) {
            throw new GremlinException("Execution failed. Reason: " + e.getMessage());
        }
    }

    public Object executeAndConvert(String query) {
        Object result = this.executeGremlinQuery(query);
        return this.convertResult(result);
    }

    protected Object convertResult(Object result) {
        this.converter.setProperties(this.converterProps);
        return this.converter.convert(result);
    }
}

