/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.report;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.report.GraphReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphReportImpl
implements GraphReport {
    protected static final Logger LOG = LoggerFactory.getLogger(GraphReportImpl.class);
    private JsonArray report = new JsonArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecord(JsonObject record) {
        JsonArray jsonArray = this.report;
        synchronized (jsonArray) {
            this.report.add((Object)record);
        }
    }

    @Override
    public JsonObject dumpReportData(int modelVersion, boolean deepCopy) {
        return new JsonObject().put("modelVersion", (Object)1).put("records", (Object)this.dumpRecords(deepCopy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonArray dumpRecords(boolean deepCopy) {
        JsonArray jsonArray = this.report;
        synchronized (jsonArray) {
            if (deepCopy) {
                return this.report.copy();
            }
            return new JsonArray(new ArrayList(this.report.getList()));
        }
    }

    public JsonArray getRecords() {
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        JsonArray jsonArray = this.report;
        synchronized (jsonArray) {
            this.report.clear();
        }
    }

    @Override
    public void restoreReportData(JsonObject dump) {
        int modelVersion = dump.getInteger("modelVersion", Integer.valueOf(1));
        if (modelVersion != 1) {
            throw new IllegalArgumentException("Report model version " + modelVersion + " not supported");
        }
        this.restoreRecords(dump.getJsonArray("records"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreRecords(JsonArray reportRecords) {
        JsonArray jsonArray = this.report;
        synchronized (jsonArray) {
            this.report.clear();
            for (Object obj : reportRecords) {
                this.report.add(obj);
            }
        }
    }

    @Override
    public void addMessage(String type, JsonObject sourceComponent, String message) {
        this.addMessage(type, sourceComponent, message, null);
    }

    public void addMessage(String type, JsonObject sourceComponent, String message, Map<String, Object> moreElements) {
        String logName;
        JsonObject record = this.create(sourceComponent, type, message);
        if (moreElements != null) {
            record.getMap().putAll(moreElements);
        }
        if ("unknown".equals(logName = record.getString("component")) && record.containsKey("graphId")) {
            logName = record.getString("graphId");
        }
        LOG.error("{} in {}: {}", new Object[]{type, logName, message});
        this.addRecord(record);
    }

    @Override
    public void mandatoryValueMissed(JsonObject sourceComponent, String property) {
        this.addMessage("CONF_ERROR", sourceComponent, "Mandatory property missed. Property: " + property);
    }

    @Override
    public void referenceNotFound(JsonObject sourceComponent, String reference) {
        this.addMessage("CONF_ERROR", sourceComponent, "Reference was not found. Reference: " + reference);
    }

    @Override
    public void configurationFileNotFound(JsonObject sourceComponent, String configurationFile) {
        this.addMessage("CONF_ERROR", sourceComponent, "Configuration file was not found. File: " + configurationFile);
    }

    @Override
    public void componentDuplicated(JsonObject sourceComponent, JsonObject duplicatedComponent) {
        this.addMessage("CONF_ERROR", duplicatedComponent, "Component duplicated. Source [Id: " + sourceComponent.getString("id") + ", Type: " + sourceComponent.getString("type") + ", Name: " + sourceComponent.getString("name") + ", Repository: " + sourceComponent.getString("repository") + ", Directory: " + sourceComponent.getString("directoryPath") + "] Duplicate [Id: " + duplicatedComponent.getString("id") + ", Type: " + duplicatedComponent.getString("type") + ", Name: " + duplicatedComponent.getString("name") + ", Repository: " + duplicatedComponent.getString("repository") + ", Directory: " + duplicatedComponent.getString("directoryPath") + "]");
    }

    @Override
    public void conventionNotMatched(JsonObject sourceComponent, String pattern, String value) {
        this.addMessage("CONF_ERROR", sourceComponent, "Value does not match the convention. Value: '" + value + "'. Pattern: " + pattern);
    }

    @Override
    public void exceptionThrown(JsonObject sourceComponent, Exception exception) {
        this.addMessage("EXCEPTION", sourceComponent, "Exception was thrown while handling '" + sourceComponent.getString("id") + "': " + exception.getMessage() + "\nStacktrace:\n" + String.valueOf(Arrays.asList(exception.getStackTrace())));
        LOG.error("Exception: ", (Throwable)exception);
    }

    @Override
    public void internalError(String message) {
        this.addMessage("ERROR", null, message);
    }

    @Override
    public void mergingError(JsonObject sourceDesc, String message) {
        String desc = InvalidGraphException.descToName(sourceDesc);
        this.addMessage("MERGE_ERROR", null, message, Collections.singletonMap("graphId", desc));
    }

    @Override
    public void mergingError(JsonObject sourceDesc, Exception exception) {
        String desc = InvalidGraphException.descToName(sourceDesc);
        String message = exception instanceof InvalidGraphException ? ((InvalidGraphException)exception).getReason() : exception.getMessage();
        this.addMessage("MERGE_ERROR", null, message, Collections.singletonMap("graphId", desc));
    }

    protected JsonObject create(JsonObject component, String type, String message) {
        String componentName = component != null ? component.getString("id", "unknown") : "unknown";
        JsonObject result = new JsonObject().put("type", (Object)type).put("message", (Object)(component == null ? message : this.express(component.getMap(), message))).put("component", (Object)componentName);
        return result;
    }

    protected String express(Map<String, Object> values, String message) {
        if (!message.contains("$")) {
            return message;
        }
        StringSubstitutor sub = new StringSubstitutor(values);
        return sub.replace(message);
    }
}

