/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.context.FlowContext;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversalSource;
import org.qubership.itool.modules.report.GraphReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowTask {
    protected static final Logger LOG = LoggerFactory.getLogger(FlowTask.class);
    public static final String TASK_ADDRESS_PREFIX = "task.";
    public static final String PROGRESS_PATH = "progress";
    @Resource
    protected Vertx vertx;
    @Resource
    protected FlowContext flowContext;
    @Resource
    protected GraphReport report;
    @Resource
    protected Graph graph;
    private Long executionStart;

    protected String[] features() {
        return new String[0];
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected JsonObject config() {
        return this.flowContext.getConfig();
    }

    public String toString() {
        return super.toString() + "[fiid=" + (this.flowContext == null ? "<null>" : this.flowContext.getFlowInstanceId()) + "]";
    }

    protected abstract void taskStart(Promise<?> var1) throws Exception;

    public Future<?> startInFlow() {
        return Future.future(taskPromise -> this.startInFlow((Promise<?>)taskPromise));
    }

    protected void startInFlow(Promise<?> taskPromise) {
        String taskAddress = this.getTaskAddress();
        String[] features = this.features();
        String fiid = this.flowContext.getFlowInstanceId();
        if (this.flowContext.isBreakRequested() && !Arrays.asList(features).contains("unskippable")) {
            this.getLogger().info("Task {} [fiid={}] is skipped", (Object)taskAddress, (Object)fiid);
            this.taskCompleted(taskPromise);
            return;
        }
        HashSet<String> disabledFeatures = new HashSet<String>(Arrays.asList(this.config().getString("disabledFeatures", "").split("\\s*,\\s*")));
        for (String feature : features) {
            if (!disabledFeatures.contains(feature)) continue;
            this.getLogger().info("Task {} [fiid={}] ignored because feature {} is disabled", new Object[]{taskAddress, fiid, feature});
            this.saveProgressIfRequired().onComplete(r -> this.taskCompleted(taskPromise));
            return;
        }
        this.executionStart = System.nanoTime();
        this.getLogger().info("Task started: {} [fiid={}]", (Object)taskAddress, (Object)fiid);
        this.saveProgressIfRequired().onComplete(r -> {
            try {
                this.taskStart(taskPromise);
            }
            catch (Throwable e) {
                this.report.internalError("Failed to execute the task '" + taskAddress + "' [fiid=" + fiid + "], exception: " + ExceptionUtils.getStackTrace((Throwable)e));
                this.taskCompleted(taskPromise);
            }
        });
    }

    protected void taskCompleted(Promise<?> taskPromise) {
        String lastStep;
        String taskAddress = this.getTaskAddress();
        if (this.executionStart != null) {
            this.getLogger().info("Task {} [fiid={}] finished in {}.", new Object[]{taskAddress, this.flowContext.getFlowInstanceId(), Duration.ofNanos(System.nanoTime() - this.executionStart)});
        }
        if ((lastStep = this.config().getString("lastStep")) != null && (TASK_ADDRESS_PREFIX + lastStep).equals(taskAddress)) {
            this.flowContext.setBreakRequested(true);
        }
        taskPromise.tryComplete();
    }

    protected Future<?> joinFuturesAndHandleResult(List<? extends Future<?>> futureList) {
        return Future.join(futureList).onFailure(e -> {
            this.getLogger().error("Internal errors were encountered during execution of block of futures: ");
            futureList.stream().forEach(f -> {
                if (f.failed()) {
                    this.report.internalError(ExceptionUtils.getStackTrace((Throwable)f.cause()));
                }
            });
        }).onSuccess(res -> this.getLogger().debug("{} futures completed", (Object)futureList.size()));
    }

    private Future<Void> saveProgressIfRequired() {
        String saveProgress = this.config().getString("saveProgress");
        if (this.saveProgressForThisTask(saveProgress)) {
            String taskName = this.getTaskAddress();
            this.getLogger().info("Save progress before execute step '{}'", (Object)taskName);
            return this.vertx.executeBlocking(() -> {
                this.flowContext.dumpDataToFile(new File(PROGRESS_PATH), taskName + ".json");
                return null;
            }).onFailure(e -> this.report.internalError("Failed to save the progress for task '" + taskName + "', reason: " + ExceptionUtils.getStackTrace((Throwable)e)));
        }
        return Future.succeededFuture();
    }

    public String getTaskAddress() {
        Object address = this.getClass().getSimpleName();
        address = ((String)address).replaceFirst("(Task|Verticle)$", "");
        address = TASK_ADDRESS_PREFIX + StringUtils.uncapitalize((String)address);
        return address;
    }

    protected boolean saveProgressForThisTask(String saveProgress) {
        if (StringUtils.isBlank((CharSequence)saveProgress) || saveProgress.equals("false")) {
            return false;
        }
        if (saveProgress.equals("true")) {
            return true;
        }
        String taskNameShort = this.getTaskAddress().substring(TASK_ADDRESS_PREFIX.length());
        return Arrays.asList(saveProgress.split("\\s*,\\s*")).contains(taskNameShort);
    }

    public static List<JsonObject> getComponents(Graph graph, JsonObject domain) {
        return graph.traversal().V(domain.getString("id")).out(new String[0]).hasKey("repository", "details").toList();
    }

    public static GraphTraversal<JsonObject, JsonObject> V(Graph graph, List<String> vertexIds) {
        return new GraphTraversalSource(graph).V(vertexIds.toArray(new String[vertexIds.size()]));
    }

    protected GraphTraversal<JsonObject, JsonObject> V(List<String> vertexIds) {
        return FlowTask.V(this.graph, vertexIds);
    }

    public static GraphTraversal<JsonObject, JsonObject> V(Graph graph, String ... vertexIds) {
        return new GraphTraversalSource(graph).V(vertexIds);
    }

    protected GraphTraversal<JsonObject, JsonObject> V(String ... vertexIds) {
        return FlowTask.V(this.graph, vertexIds);
    }

    public static GraphTraversal<JsonObject, JsonObject> E(Graph graph, List<String> edgeIds) {
        return new GraphTraversalSource(graph).E(edgeIds.toArray(new String[edgeIds.size()]));
    }

    protected GraphTraversal<JsonObject, JsonObject> E(List<String> edgeIds) {
        return FlowTask.E(this.graph, edgeIds);
    }

    public static GraphTraversal<JsonObject, JsonObject> E(Graph graph, String ... edgeIds) {
        return new GraphTraversalSource(graph).E(edgeIds);
    }

    protected GraphTraversal<JsonObject, JsonObject> E(String ... edgeIds) {
        return FlowTask.E(this.graph, edgeIds);
    }
}

