/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence.summary;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.tasks.confluence.AbstractConfluenceGenerationPageVerticle;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSummaryJavaDependenciesVerticle
extends AbstractConfluenceGenerationPageVerticle {
    protected Logger LOG = LoggerFactory.getLogger(ConfluenceSummaryJavaDependenciesVerticle.class);
    @Resource
    Provider<ConfluencePage> confluencePageProvider;

    @Override
    protected List<ConfluencePage> prepareConfluencePageList(String department) {
        return null;
    }

    @Override
    protected List<ConfluencePage> prepareConfluencePageList() {
        ArrayList<Pair<JsonObject, List<JsonObject>>> componentDirectDep = new ArrayList<Pair<JsonObject, List<JsonObject>>>();
        ArrayList<Pair<JsonObject, List<JsonObject>>> componentTransitiveDep = new ArrayList<Pair<JsonObject, List<JsonObject>>>();
        List components = this.V(new String[0]).hasType("domain").out(new String[0]).toList();
        for (JsonObject component : components) {
            String componentId = component.getString("id");
            GraphTraversal<JsonObject, JsonObject> directTraversal = this.V(componentId).as("C", new String[0]).out("module").outE("dependency").has("scope", P.neq("test")).has("component", componentId).inV().dedup();
            componentDirectDep.add((Pair<JsonObject, List<JsonObject>>)Pair.of((Object)component, directTraversal.clone().toList()));
            List transitiveDependencies = directTraversal.clone().outE("dependency").has("scope", P.neq("test")).has("component", componentId).inV().dedup().repeat(__.outE("dependency").has("scope", P.neq("test")).has("component", componentId).inV().dedup()).emit().dedup().toList();
            componentTransitiveDep.add((Pair<JsonObject, List<JsonObject>>)Pair.of((Object)component, transitiveDependencies));
        }
        HashMap<String, JsonObject> map = new HashMap<String, JsonObject>();
        this.addDependenciesToMap(map, componentDirectDep, "directDependencies");
        this.addDependenciesToMap(map, componentTransitiveDep, "transitiveDependencies");
        List librariesList = map.values().stream().map(depData -> new JsonObject().put("groupId", (Object)depData.getString("groupId")).put("artifactId", (Object)depData.getString("artifactId")).put("version", (Object)depData.getString("version")).put("directDependencies", (Object)depData.getJsonArray("directDependencies")).put("transitiveDependencies", (Object)depData.getJsonArray("transitiveDependencies"))).sorted((o1, o2) -> {
            String o1groupId = o1.getString("groupId");
            String o1artifactId = o1.getString("artifactId");
            String o1version = o1.getString("version");
            String o2groupId = o2.getString("groupId");
            String o2artifactId = o2.getString("artifactId");
            String o2version = o2.getString("version");
            if (o1groupId.equals(o2groupId) && o1artifactId.equals(o2artifactId) && o1version.equals(o2version)) {
                return 0;
            }
            if (!o1groupId.equals(o2groupId)) {
                return o1groupId.compareTo(o2groupId);
            }
            if (!o1artifactId.equals(o2artifactId)) {
                return o1artifactId.compareTo(o2artifactId);
            }
            if (o1version != null && o2version == null) {
                return 1;
            }
            if (o1version == null && o2version != null) {
                return -1;
            }
            return P.lteVersion(o1version).test(o2version) ? -1 : 1;
        }).collect(Collectors.toList());
        ArrayList<ConfluencePage> confluencePageList = new ArrayList<ConfluencePage>();
        ConfluencePage page = (ConfluencePage)this.confluencePageProvider.get();
        confluencePageList.add(page);
        page.setTitle("Java Dependencies");
        page.setParentTitle("Summary");
        page.setType("summary");
        page.setTemplate("summary/javaDependencies.ftlh");
        page.setDirectoryPath("summary/");
        page.setFileName("javaDependencies");
        page.addDataModel("librariesList", librariesList);
        return confluencePageList;
    }

    private void addDependenciesToMap(Map<String, JsonObject> map, List<Pair<JsonObject, List<JsonObject>>> componentDep, String depType) {
        for (Pair<JsonObject, List<JsonObject>> data : componentDep) {
            List directDep = (List)data.getRight();
            for (JsonObject dep : directDep) {
                JsonObject javaDependency = map.computeIfAbsent(dep.getString("id"), key -> new JsonObject().put("groupId", (Object)dep.getString("groupId")).put("artifactId", (Object)dep.getString("artifactId")).put("version", (Object)dep.getString("version")));
                JsonArray directDeps = JsonUtils.getOrCreateJsonArray(javaDependency, depType);
                directDeps.add(data.getLeft());
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

