/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.export;

import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellUtil;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportVerticle
extends FlowTask {
    protected Logger LOG = LoggerFactory.getLogger(ExcelExportVerticle.class);
    Map<String, CellStyle> cellStylesMap = new HashMap<String, CellStyle>();
    private static final String COMP_NAME_STYLE = "compNameStyle";
    private static final String ERROR_COMP_NAME_STYLE = "errorCompNameStyle";
    private static final String PROPERTY_STYLE = "propertyStyle";
    public static Map<String, String> readablePropertyToFieldNameMap = Map.ofEntries(Map.entry("Owner", "owner"), Map.entry("Abbreviation", "abbreviation"), Map.entry("DNS name", "dnsName"), Map.entry("Domain", "domain"), Map.entry("Description", "description"), Map.entry("TMF spec", "tmfSpec"), Map.entry("Type", "type"), Map.entry("Sticky sessions", "stickySessions"), Map.entry("Language", "language"), Map.entry("Framework", "framework"), Map.entry("Reactive", "reactive"));

    @Override
    protected String[] features() {
        return new String[]{"excelExport"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        String exportPath = this.config().getString("excelExport");
        if (exportPath == null) {
            this.LOG.error("excelExport property is not set");
        }
        this.LOG.info("Scheduling blocking execution of ExcelExport process in a separate thread");
        WorkerExecutor executor = this.vertx.createSharedWorkerExecutor("excel-export-worker-pool", 1, 60L, TimeUnit.MINUTES);
        String finalExportPath = exportPath;
        executor.executeBlocking(() -> {
            try {
                this.buildInventorizationXls(finalExportPath);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to build Excel export " + finalExportPath + ": " + e.getMessage());
            }
            return null;
        }).onSuccess(r -> this.taskCompleted(taskPromise)).onFailure(r -> {
            this.report.exceptionThrown(new JsonObject().put("id", (Object)"iTool"), (Exception)r);
            this.taskCompleted(taskPromise);
        });
    }

    private Map<String, CellStyle> buildCustomCellStyles(HSSFWorkbook book) {
        HashMap<String, CellStyle> cellStylesMap = new HashMap<String, CellStyle>();
        HSSFFont normalCompNameFont = book.createFont();
        normalCompNameFont.setBold(true);
        HSSFFont errorCompNameFont = book.createFont();
        errorCompNameFont.setColor(IndexedColors.RED.getIndex());
        errorCompNameFont.setBold(true);
        HSSFCellStyle compNameStyle = book.createCellStyle();
        compNameStyle.setWrapText(true);
        compNameStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        compNameStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex());
        compNameStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        compNameStyle.setFont((Font)normalCompNameFont);
        cellStylesMap.put(COMP_NAME_STYLE, (CellStyle)compNameStyle);
        HSSFCellStyle errorCompNameStyle = book.createCellStyle();
        errorCompNameStyle.setWrapText(true);
        errorCompNameStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        errorCompNameStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex());
        errorCompNameStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        errorCompNameStyle.setFont((Font)errorCompNameFont);
        cellStylesMap.put(ERROR_COMP_NAME_STYLE, (CellStyle)errorCompNameStyle);
        HSSFCellStyle propertyStyle = book.createCellStyle();
        propertyStyle.setWrapText(true);
        propertyStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        propertyStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex());
        propertyStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        propertyStyle.setFont((Font)normalCompNameFont);
        cellStylesMap.put(PROPERTY_STYLE, (CellStyle)propertyStyle);
        return cellStylesMap;
    }

    private void addSheetContent(Sheet sheet, JsonObject domain) {
        List<JsonObject> components = this.graph.getSuccessors(domain.getString("id"), false).stream().filter(o -> o.getString("repository") != null && o.getJsonObject("details") != null).collect(Collectors.toList());
        int row = 0;
        this.addComponentNamesRow(sheet, components, row++);
        this.addDetailsRow(sheet, components, "Owner", row++);
        this.addDetailsRow(sheet, components, "Abbreviation", row++);
        this.addDetailsRow(sheet, components, "DNS name", row++);
        this.addDetailsRow(sheet, components, "Domain", row++);
        this.addDetailsRow(sheet, components, "Description", row++);
        this.addDetailsRow(sheet, components, "TMF spec", row++);
        this.addDetailsRow(sheet, components, "Type", row++);
        this.addDetailsRow(sheet, components, "Sticky sessions", row++);
        this.addDetailsRow(sheet, components, "Language", row++);
        this.addDetailsRow(sheet, components, "Framework", row++);
        this.addDetailsRow(sheet, components, "Reactive", row++);
        this.addPropertyRow(sheet, components, "Database", row++, c -> JsonUtils.getOrCreateJsonArray(c, JsonPointer.from((String)"/details/database/database")).stream().map(e -> ((JsonObject)e).getString("item")).collect(Collectors.joining(", ")));
        this.addPropertyRow(sheet, components, "External index", row++, c -> JsonPointer.from((String)"/details/database/externalIndices/item").queryJson(c).toString());
        this.addPropertyRow(sheet, components, "External cache", row++, c -> JsonPointer.from((String)"/details/database/externalCache/item").queryJson(c).toString());
        this.addSectionNameRow(sheet, components, "RabbitMQ:", row++);
        this.addPropertyRow(sheet, components, "  * Producer (Exchanges)", row++, c -> this.retrievePropertyListAsString("/details/messageQueues/rabbitMQ/producer", (JsonObject)c));
        this.addPropertyRow(sheet, components, "  * Consumer (Queues)", row++, c -> this.retrievePropertyListAsString("/details/messageQueues/rabbitMQ/consumer", (JsonObject)c));
        this.addSectionNameRow(sheet, components, "Kafka:", row++);
        this.addPropertyRow(sheet, components, "  * Producer (Topics)", row++, c -> this.retrievePropertyListAsString("/details/messageQueues/kafka/producer", (JsonObject)c));
        this.addPropertyRow(sheet, components, "  * Consumer (Topics)", row++, c -> this.retrievePropertyListAsString("/details/messageQueues/kafka/consumer", (JsonObject)c));
        this.addPropertyRow(sheet, components, "Startup dependency", row++, c -> this.retrievePropertyListAsString("/details/dependencies/startup", (JsonObject)c));
        this.addPropertyRow(sheet, components, "Mandatory dependency", row++, c -> this.retrievePropertyListAsString("/details/dependencies/mandatory", (JsonObject)c));
        this.addPropertyRow(sheet, components, "Optional dependency", row++, c -> this.retrievePropertyListAsString("/details/dependencies/optional", (JsonObject)c));
        this.addPropertyRow(sheet, components, "Git repository", row++, c -> c.getString("repository"));
        this.addPropertyRow(sheet, components, "Confluence article", row++, c -> this.retrievePropertyListAsString("/details/documentationLink", (JsonObject)c));
        this.addPropertyRow(sheet, components, "OpenAPI/Swagger", row++, c -> JsonPointer.from((String)"/details/api/openApi").queryJson(c).toString());
        this.addPropertyRow(sheet, components, "API spec published", row++, c -> ((JsonArray)JsonPointer.from((String)"/details/api/apiSpecPublished").queryJson(c)).stream().map(String.class::cast).collect(Collectors.joining(", ")));
        this.addPropertyRow(sheet, components, "API versioning", row++, c -> JsonPointer.from((String)"/details/api/apiVersioning").queryJson(c).toString());
        this.addPropertyRow(sheet, components, "ZK DB connection support", row++, c -> JsonUtils.getOrCreateJsonArray(c, JsonPointer.from((String)"/details/database/database")).stream().map(e -> ((JsonObject)e).getString("viaZookeeper")).collect(Collectors.joining(", ")));
        this.addSectionNameRow(sheet, components, "Blue-Green:", row++);
        this.addPropertyRow(sheet, components, "  * HTTP request", row++, c -> JsonPointer.from((String)"/features/blueGreen/httpRequest").queryJson(c).toString());
        this.addPropertyRow(sheet, components, "  * HTTP callback", row++, c -> JsonPointer.from((String)"/features/blueGreen/httpCallback").queryJson(c).toString());
        this.addPropertyRow(sheet, components, "  * Zeebe workers", row++, c -> JsonPointer.from((String)"/features/blueGreen/zeebeWorkers").queryJson(c).toString());
        this.addPropertyRow(sheet, components, "  * MessageQueue", row++, c -> JsonPointer.from((String)"/features/blueGreen/messageQueueConsumers").queryJson(c).toString());
    }

    protected String retrieveLibsString(String pointer, JsonObject c) {
        JsonArray dependencies = (JsonArray)JsonPointer.from((String)pointer).queryJson((Object)c);
        if (dependencies.size() == 0) {
            return "N/A";
        }
        return String.join((CharSequence)", ", dependencies.stream().map(d -> ((JsonObject)d).getString("artifactId")).collect(Collectors.toList()));
    }

    protected String retrievePropertyListAsString(String pointer, JsonObject c) {
        JsonArray results = (JsonArray)JsonPointer.from((String)pointer).queryJson((Object)c);
        if (results == null || results.size() == 0) {
            return "";
        }
        return String.join((CharSequence)", ", results.getList());
    }

    public void buildInventorizationXls(String exportFileLocation) throws IOException {
        String reportFolderName = FSUtils.getFolder(exportFileLocation);
        File reportFolder = new File(reportFolderName);
        if (!reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        try (HSSFWorkbook book = new HSSFWorkbook();){
            HSSFPalette palette = book.getCustomPalette();
            palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.LIGHT_BLUE.getIndex(), (byte)-67, (byte)-41, (byte)-18);
            this.cellStylesMap = this.buildCustomCellStyles(book);
            List domains = this.V(new String[0]).hasType("domain").toList();
            for (JsonObject domain : domains) {
                HSSFSheet sheet = book.createSheet(domain.getString("id"));
                this.addSheetContent((Sheet)sheet, domain);
                this.reFormatSheet((Sheet)sheet, domain);
            }
            try (FileOutputStream os = new FileOutputStream(String.valueOf(reportFolder) + File.separator + this.getFileName(exportFileLocation));){
                book.write((OutputStream)os);
            }
        }
    }

    private String getFileName(String exportFileLocation) {
        String fileName = FilenameUtils.getBaseName((String)exportFileLocation);
        String extension = FilenameUtils.getExtension((String)exportFileLocation);
        return fileName + LocalDateTime.now().format(DateTimeFormatter.ofPattern("_yyyy-MM-dd_HHmmss.")) + extension;
    }

    private void reFormatSheet(Sheet sheet, JsonObject domain) {
        sheet.autoSizeColumn(0);
        List components = this.graph.getSuccessors(domain.getString("id"), false).stream().filter(o -> "microservice".equals(o.getString("type")) || "library".equals(o.getString("type"))).collect(Collectors.toList());
        for (int i = 1; i <= components.size(); ++i) {
            sheet.setColumnWidth(i, 6000);
        }
    }

    protected void addComponentNamesRow(Sheet sheet, List<JsonObject> components, int rowIndex) {
        this.addRow(sheet, components, rowIndex, cell -> {}, (cell, component) -> {
            cell.setCellStyle(this.cellStylesMap.get(COMP_NAME_STYLE));
            CellUtil.setAlignment((Cell)cell, (HorizontalAlignment)HorizontalAlignment.CENTER);
            String name = component.getJsonObject("details").getString("name");
            cell.setCellValue(name == null ? "unknown" : name.replace(" ", "\n"));
        });
    }

    private void addRow(Sheet sheet, List<JsonObject> components, int rowIndex, Consumer<Cell> headerCellBuilder, BiConsumer<Cell, JsonObject> cellBuilder) {
        Row row = sheet.createRow(rowIndex);
        int columnIndex = 0;
        Cell nameCell = row.createCell(columnIndex++);
        headerCellBuilder.accept(nameCell);
        for (JsonObject component : components) {
            Cell cell = row.createCell(columnIndex++);
            cellBuilder.accept(cell, component);
        }
    }

    protected void addSectionNameRow(Sheet sheet, List<JsonObject> components, String propertyName, int rowIndex) {
        this.addRow(sheet, components, rowIndex, cell -> {
            cell.setCellStyle(this.cellStylesMap.get(PROPERTY_STYLE));
            cell.setCellValue(propertyName);
        }, (cell, component) -> cell.setCellStyle(this.cellStylesMap.get(PROPERTY_STYLE)));
    }

    protected void addDetailsRow(Sheet sheet, List<JsonObject> components, String propertyName, int rowIndex) {
        this.addPropertyRow(sheet, components, propertyName, rowIndex, component -> {
            Object obj = component.getJsonObject("details").getValue(readablePropertyToFieldNameMap.get(propertyName));
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof JsonArray) {
                String result = ((JsonArray)obj).getList().stream().map(o -> o.toString()).collect(Collectors.joining(", "));
                return result;
            }
            return "";
        });
    }

    protected void addPropertyRow(Sheet sheet, List<JsonObject> components, String propertyName, int rowIndex, Function<JsonObject, String> cellValueProducer) {
        this.addRow(sheet, components, rowIndex, cell -> {
            cell.setCellStyle(this.cellStylesMap.get(PROPERTY_STYLE));
            cell.setCellValue(propertyName);
        }, (cell, component) -> {
            String propertyValue = "";
            try {
                propertyValue = (String)cellValueProducer.apply((JsonObject)component);
            }
            catch (NullPointerException e) {
                propertyValue = "Field was not found in model";
                cell.setCellStyle(this.cellStylesMap.get(ERROR_COMP_NAME_STYLE));
            }
            cell.setCellValue(propertyValue);
        });
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

