/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.init;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.List;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.GraphHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FillMandatoryValuesVerticle
extends FlowTask {
    protected Logger LOGGER = LoggerFactory.getLogger(FillMandatoryValuesVerticle.class);

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        List components = this.V(new String[0]).hasType("domain").out(new String[0]).hasKeys("repository").toList();
        for (JsonObject component : components) {
            this.tryToFillMandatoryComponentFields(component);
        }
        List domains = this.V(new String[0]).hasType("domain").toList();
        for (JsonObject domain : domains) {
            this.tryToFillMandatoryDomainFields(domain);
        }
        this.taskCompleted(taskPromise);
    }

    private void tryToFillMandatoryComponentFields(JsonObject component) {
        String name = component.getString("name");
        if (null == name) {
            name = (String)JsonPointer.from((String)"/details/name").queryJson((Object)component);
        }
        if (null == name) {
            name = (String)JsonPointer.from((String)"/details/dnsName").queryJson((Object)component);
        }
        if (null == name) {
            name = component.getString("id");
        }
        this.getLogger().warn("{} : Component name was set to {}", (Object)component.getString("id"), (Object)name);
        component.put("name", (Object)name);
        String type = component.getString("type", "unknown");
        component.put("type", (Object)type);
        JsonObject details = component.getJsonObject("details");
        if (details != null && details.getString("abbreviation") == null) {
            if (component.getString("abbreviation") == null) {
                component.put("abbreviation", (Object)component.getString("id"));
            }
            details.put("abbreviation", (Object)component.getString("abbreviation"));
        }
        if (component.getString("abbreviation") == null) {
            component.put("abbreviation", (Object)component.getString("id"));
        }
        if (component.getBoolean("isMicroservice") == null) {
            component.put("isMicroservice", (Object)GraphHelper.isComponentAMicroservice(this.graph, component));
        }
    }

    private void tryToFillMandatoryDomainFields(JsonObject domain) {
        String domainId = domain.getString("id");
        domain.put("abbreviation", (Object)ConfigUtils.stripDomainId(domainId));
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

