/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;
import org.qubership.itool.tasks.FlowTask;

public abstract class AbstractParseFileDataTask
extends FlowTask {
    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        List<Map<String, JsonObject>> tuples = this.getTuples();
        for (Map<String, JsonObject> tuple : tuples) {
            JsonObject domain = tuple.get("D");
            JsonObject component = tuple.get("C");
            JsonObject file = tuple.get("F");
            try {
                this.processFile(domain, component, file);
            }
            catch (Exception e) {
                this.report.addMessage("configuration", component, e.getMessage() + " // File " + file.getString("path") + " [" + component.getString("id") + "]");
            }
        }
        this.taskCompleted(taskPromise);
    }

    protected abstract List<Map<String, JsonObject>> getTuples();

    protected abstract void processFile(JsonObject var1, JsonObject var2, JsonObject var3);
}

