/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.configuration;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import jakarta.inject.Provider;
import java.io.File;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.parsing.InventoryJsonParser;
import org.qubership.itool.modules.processor.GraphMetaInfoSupport;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseApplicationInventoryFileTask
extends FlowTask {
    @Resource
    Provider<InventoryJsonParser> inventoryJsonParserProvider;
    protected static final Logger LOG = LoggerFactory.getLogger(ParseApplicationInventoryFileTask.class);

    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        JsonObject config = this.config();
        String repository = config.getString("ciRepository");
        String releaseBranch = (String)JsonPointer.from((String)"/git/releaseBranch").queryJson((Object)config);
        String inputDir = config.getString("ciInputDirectory");
        File appInvJson = new File(inputDir, "application_inventory.json");
        if (!appInvJson.isFile()) {
            appInvJson = new File(inputDir, "application-inventory.json");
        }
        this.getLogger().info("Parsing {}", (Object)appInvJson);
        InventoryJsonParser parser = (InventoryJsonParser)this.inventoryJsonParserProvider.get();
        JsonObject inv = JsonUtils.readJsonFile(appInvJson.getPath());
        String appId = inv.getString("id");
        String appName = inv.getString("name", "unknown");
        String appVersion = inv.getString("version", "unknown");
        if (StringUtils.isEmpty((CharSequence)appId)) {
            appId = String.join((CharSequence)":", "application", appName, appVersion);
        }
        GraphMetaInfoSupport.initMetaInfoForApplication(this.graph, appName, appVersion);
        JsonObject application = new JsonObject().put("id", (Object)appId).put("type", (Object)"application").put("name", (Object)appName).put("version", (Object)appVersion);
        this.graph.addVertexUnderRoot(application);
        JsonArray components = inv.getJsonArray("components");
        HashMap<String, JsonObject> domainsCache = new HashMap<String, JsonObject>();
        for (Object o : components) {
            JsonObject compDesc = JsonUtils.asJsonObject(o);
            String compId = compDesc.getString("id");
            if (StringUtils.isEmpty((CharSequence)compId)) {
                this.report.mandatoryValueMissed(new JsonObject().put("id", (Object)"unknown"), "id");
                continue;
            }
            JsonObject component = new JsonObject().put("id", (Object)compId).put("type", (Object)"unknown").put("isMock", (Object)false).put("releaseBranch", (Object)releaseBranch).put("repository", (Object)repository);
            String domainId = compDesc.getString("domain");
            if (StringUtils.isEmpty((CharSequence)domainId)) {
                this.report.mandatoryValueMissed(component, "id");
                domainId = "orphans";
            } else {
                domainId = ConfigUtils.fillDomainId(domainId);
            }
            JsonObject domain = domainsCache.computeIfAbsent(domainId, k -> {
                JsonObject mockDomain = new JsonObject().put("id", k).put("type", (Object)"domain").put("isMock", (Object)true).put("department", (Object)"unknown");
                this.graph.addVertexUnderRoot(mockDomain);
                return mockDomain;
            });
            this.graph.addVertex(domain, component);
            this.graph.addEdge(application, component);
            this.getLogger().info("Component {} created in domain {} and application {}", new Object[]{compId, domainId, appId});
            parser.parse(domain, component, compDesc);
        }
        this.taskCompleted(taskPromise);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected JsonObject config() {
        return super.config();
    }
}

