/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.configuration;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.tasks.parsing.AbstractParseFileTask;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.GitUtils;
import org.qubership.itool.utils.YamlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseComponentConfFilesVerticle
extends AbstractParseFileTask {
    protected Logger LOGGER = LoggerFactory.getLogger(ParseComponentConfFilesVerticle.class);
    @Resource
    Provider<YamlParser> yamlParserProvider;

    @Override
    protected String[] getFilePatterns() {
        return new String[]{"Dockerfile", "**/package.json", "**/settings.gradle", "**/settings.gradle.kts", "**/gradle.properties", "**/build.gradle", "**/pom.xml", "**/go.mod", "**/src/main/resources/application.y*", "**/src/main/resources/application.json", "inventory.json"};
    }

    protected boolean isSpringYamlFile(String fileName) {
        String tail = Path.of(fileName, new String[0]).getFileName().toString();
        return "application.yml".equals(tail) || "application.yaml".equals(tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseSingleFile(JsonObject domain, JsonObject component, String fileName) throws IOException {
        File parsedFile = new File(fileName);
        if (!parsedFile.isFile()) {
            return;
        }
        JsonObject jsonObject = component;
        synchronized (jsonObject) {
            String relativePath = FSUtils.relativePath(component, fileName);
            File file = new File(relativePath);
            Path filePath = file.toPath();
            Object path = "";
            JsonObject sourceVertex = component;
            for (int i = 0; i < filePath.getNameCount() - 1; ++i) {
                String name = filePath.getName(i).toString();
                path = (String)path + "/" + name;
                sourceVertex = this.getOrCreateDirectoryVertex(component, sourceVertex, name, (String)path, fileName);
            }
            String name = filePath.getName(filePath.getNameCount() - 1).toString();
            path = (String)path + "/" + name;
            this.createVertexNode(component, sourceVertex, name, (String)path, fileName, "file");
        }
    }

    private JsonObject createVertexNode(JsonObject component, JsonObject sourceVertex, String name, String path, String fileName, String type) throws IOException {
        String fileLink = GitUtils.buildRepositoryLink(component, fileName.split(name)[0] + name, this.config());
        JsonObject vertex = new JsonObject();
        vertex.put("id", (Object)UUID.randomUUID());
        vertex.put("type", (Object)type);
        vertex.put("path", (Object)path.substring(1));
        vertex.put("fileLink", (Object)fileLink);
        vertex.put("name", (Object)name);
        JsonObject edge = new JsonObject().put("type", (Object)type);
        this.graph.addEdge(sourceVertex, vertex, edge);
        this.getLogger().debug("Config file component added. id: {}, type: {}, name: {}, fileLink: {}", new Object[]{vertex.getString("id"), type, name, fileLink});
        if (type.equals("file")) {
            this.storeFileContent(component, vertex, fileName);
        }
        return vertex;
    }

    private JsonObject getOrCreateDirectoryVertex(JsonObject component, JsonObject sourceVertex, String name, String path, String fileName) throws IOException {
        JsonObject successor = (JsonObject)this.V(sourceVertex.getString("id")).out(new String[0]).has("type", "directory").has("name", name).next();
        sourceVertex = successor != null ? successor : this.createVertexNode(component, sourceVertex, name, path, fileName, "directory");
        return sourceVertex;
    }

    private void storeFileContent(JsonObject component, JsonObject vertex, String fileName) throws IOException {
        String content = FSUtils.readFileAsIs(fileName);
        vertex.put("content", (Object)content);
        try {
            if (fileName.endsWith(".yaml") || fileName.endsWith(".yml")) {
                YamlParser yamlParser = (YamlParser)this.yamlParserProvider.get();
                List<Object> structuredJson = yamlParser.parseYamlData(content, fileName);
                if (this.isSpringYamlFile(fileName)) {
                    yamlParser.fixSpringYamlModels(structuredJson);
                }
                vertex.put("structured", (Object)new JsonArray(structuredJson));
            } else if (fileName.endsWith(".json")) {
                Object data = Json.CODEC.fromString(content, Object.class);
                vertex.put("structured", data);
            }
        }
        catch (Exception e) {
            this.report.addMessage("EXCEPTION", component, "Exception was thrown while handling '" + fileName + "': " + e.getMessage() + "\nStacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

