/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.go;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.tasks.parsing.AbstractParseFileTask;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.LanguageUtils;
import org.qubership.itool.utils.TechNormalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseGoModFileVerticle
extends AbstractParseFileTask {
    private static final Object GO_LANGUAGE_NAME = "GoLang";
    protected Logger LOGGER = LoggerFactory.getLogger(ParseGoModFileVerticle.class);
    protected final Pattern MODULE_NAME_PATTERN = Pattern.compile("^module(\\s+).*$", 2);
    protected final Pattern GO_VERSION_PATTERN = Pattern.compile("^go(\\s+).*$", 2);
    protected final Pattern REQUIRE_PATTERN = Pattern.compile("^require(\\s+).*$", 2);

    @Override
    protected String[] getFilePatterns() {
        return new String[]{"**/go.mod"};
    }

    @Override
    protected void parseSingleFile(JsonObject domain, JsonObject component, String fileName) throws IOException {
        String goModSource = FSUtils.readFileSafe(fileName);
        if (goModSource == null) {
            this.getLogger().warn("{}: File '{}' is missing contents", (Object)component.getString("id"), (Object)fileName);
            return;
        }
        this.getLogger().debug("{}: Found file '{}', parsing it", (Object)component.getString("id"), (Object)fileName);
        JsonObject module = null;
        Iterator<String> linesIterator = Arrays.stream(goModSource.split("[\\n\\r]+")).iterator();
        ArrayList<String> linesBeforeModule = new ArrayList<String>();
        boolean moduleDetected = false;
        while (linesIterator.hasNext()) {
            JsonObject detectedVersion;
            String line = (String)linesIterator.next();
            if (!(moduleDetected || this.MODULE_NAME_PATTERN.matcher(line).matches() || line.matches("require\\s*\\(") || this.GO_VERSION_PATTERN.matcher(line).matches())) {
                linesBeforeModule.add(line);
                continue;
            }
            if (this.MODULE_NAME_PATTERN.matcher(line).matches()) {
                String moduleName = line.replaceAll("module\\s+", "");
                module = this.addModule(moduleName, component);
                moduleDetected = true;
                continue;
            }
            if (moduleDetected && this.REQUIRE_PATTERN.matcher(line).matches()) {
                this.getLogger().debug("{}: parsing dependencies", (Object)component.getString("id"));
                this.parseDependencies(linesBeforeModule.iterator(), component, module);
                linesBeforeModule.clear();
                this.parseDependencies(linesIterator, component, module);
                continue;
            }
            if (!this.GO_VERSION_PATTERN.matcher(line).matches() || (detectedVersion = TechNormalizationHelper.normalizeTechAsJson(line)) == null) continue;
            Object versionsObj = LanguageUtils.LANGUAGE_PATH_POINTER.queryJson((Object)component);
            List versions = JsonUtils.asList(versionsObj);
            if (versions == null) {
                versions = new ArrayList();
            }
            AtomicBoolean versionFound = new AtomicBoolean(false);
            List languageVersions = versions.stream().map(version -> this.updateGoVersions((JsonObject)version, detectedVersion.getString("version"), versionFound)).collect(Collectors.toList());
            if (!versionFound.get()) {
                this.getLogger().debug("{}: New language version was added: {}", (Object)component.getString("id"), (Object)detectedVersion.encode());
                languageVersions.add(detectedVersion);
            }
            LanguageUtils.LANGUAGE_PATH_POINTER.writeJson((Object)component, (Object)new JsonArray(languageVersions), true);
        }
    }

    private JsonObject updateGoVersions(JsonObject language, String detectedVersion, AtomicBoolean versionFound) {
        if (GO_LANGUAGE_NAME.equals(language.getString("name"))) {
            String languageVersion = language.getString("version");
            if (languageVersion == null && detectedVersion != null) {
                language.put("version", (Object)detectedVersion);
                versionFound.set(true);
                this.getLogger().debug("GoLang version is populated from the go.mod file: {}", (Object)detectedVersion);
            } else if (languageVersion != null && languageVersion.equals(detectedVersion)) {
                versionFound.set(true);
            }
        }
        return language;
    }

    private JsonObject addModule(String name, JsonObject component) {
        String[] artifact = name.split("/");
        String[] groupId = artifact[0].replaceAll("\\s", "").split("\\.");
        String reversedResult = this.generateGroupId(groupId);
        String artifactId = name.replaceAll("^.+?/", "");
        JsonObject module = new JsonObject().put("artifactId", (Object)artifactId).put("groupId", (Object)reversedResult).put("package", (Object)"golang").put("type", (Object)"library").put("version", (Object)"unknown");
        this.generateId(module);
        this.graph.addVertex(module, component);
        JsonObject dependencyEdge = new JsonObject().put("type", (Object)"module").put("component", (Object)component.getString("id"));
        this.graph.addEdge(component, module, dependencyEdge);
        this.getLogger().debug("{}: Added module with name {} based on value in go.mod", (Object)component.getString("id"), (Object)name);
        return module;
    }

    private void parseDependencies(Iterator<String> linesIterator, JsonObject component, JsonObject module) {
        HashSet<String> goDependenciesSet = new HashSet<String>();
        while (linesIterator.hasNext()) {
            String nextLine = linesIterator.next();
            if (StringUtils.isBlank((CharSequence)nextLine)) continue;
            if (nextLine.contains(")")) break;
            if (!StringUtils.isNotBlank((CharSequence)nextLine)) continue;
            goDependenciesSet.add(nextLine.trim());
        }
        ArrayList<JsonObject> directDependencies = new ArrayList<JsonObject>();
        ArrayList<JsonObject> indirectDependencies = new ArrayList<JsonObject>();
        ArrayList<String> indirectList = new ArrayList<String>();
        for (String goDependency : goDependenciesSet) {
            if (goDependency.contains("indirect")) {
                indirectList.add(goDependency);
                continue;
            }
            if (goDependency.equals("require (")) continue;
            if (goDependency.matches("^require\\s+.+")) {
                directDependencies.add(this.processDependency(goDependency.replaceAll("^require\\s+", "")));
            }
            try {
                directDependencies.add(this.processDependency(goDependency));
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage() + goDependency);
            }
        }
        for (String indrectDependency : indirectList) {
            try {
                indrectDependency = indrectDependency.replaceAll("\\s/+\\sindirect$", "");
                indirectDependencies.add(this.processDependency(indrectDependency));
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage(), (Object)indrectDependency);
            }
        }
        for (JsonObject destination : directDependencies) {
            this.addDependencyEdge(component.getString("id"), destination, module, false);
        }
        for (JsonObject destination : indirectDependencies) {
            this.addDependencyEdge(component.getString("id"), destination, module, true);
        }
    }

    private JsonObject processDependency(String dependency) {
        try {
            String artifactId;
            String[] artifact;
            if (dependency.contains("/")) {
                artifact = dependency.split("/");
                artifactId = dependency.replaceAll("^.+?/(.+)\\s+.+", "$1");
            } else {
                artifact = dependency.split(" ");
                artifactId = dependency.replaceAll("\\s(.+)\\s.+", "$1");
            }
            String[] url = artifact[0].replaceAll("\\s", "").split("\\.");
            String groupId = this.generateGroupId(url);
            String version = dependency.replaceAll(".+\\s(.+)", "$1").replaceAll("v", "");
            JsonObject dependencyNode = new JsonObject().put("artifactId", (Object)artifactId).put("groupId", (Object)groupId).put("package", (Object)"golang").put("version", (Object)version).put("type", (Object)"library");
            this.generateId(dependencyNode);
            return dependencyNode;
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Object)dependency);
            return null;
        }
    }

    private void addDependencyEdge(String componentId, JsonObject destination, JsonObject module, Boolean transitive) {
        JsonObject dependencyEdge = new JsonObject().put("type", (Object)"dependency").put("scope", (Object)"compile").put("transitive", (Object)transitive).put("component", (Object)componentId);
        this.graph.addEdge(module, destination, dependencyEdge);
    }

    private String generateGroupId(String[] url) {
        StringBuilder reversedString = new StringBuilder();
        for (int i = url.length - 1; i >= 0; --i) {
            reversedString.append(url[i]);
            if (i == 0) continue;
            reversedString.append(".");
        }
        return reversedString.toString();
    }

    private void generateId(JsonObject destination) {
        destination.put("id", (Object)new StringBuffer().append(destination.getString("groupId")).append(":").append(destination.getString("artifactId")).append(":").append(destination.getString("package")).append(":").append(destination.getString("version")).toString());
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

