/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.repository;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.json.JsonObject;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jgit.api.Git;
import org.qubership.itool.modules.git.GitAdapter;
import org.qubership.itool.modules.git.GitFileRetriever;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoriesPrepareSuperRepositoryVerticle
extends AbstractAggregationTaskVerticle {
    protected Logger LOGGER = LoggerFactory.getLogger(RepositoriesPrepareSuperRepositoryVerticle.class);
    @Resource
    @Nullable
    private GitFileRetriever gitFileRetriever;
    @Resource
    @Nullable
    private GitAdapter gitAdapter;

    @Override
    protected String[] features() {
        return new String[]{"repositoryUpdate"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        if (this.gitAdapter == null || this.gitFileRetriever == null) {
            this.getLogger().warn("Offline mode. Exitting.");
            this.taskCompleted(taskPromise);
            return;
        }
        this.updateRepositories().onFailure(f -> this.report.internalError("Failed to update repository: " + ExceptionUtils.getStackTrace((Throwable)f))).onComplete(r -> this.taskCompleted(taskPromise));
    }

    private Future<Void> updateRepositories() {
        List jsonObjectList = this.V(new String[0]).hasType("domain").as("domain", new String[0]).out(new String[0]).hasKeys("directoryPath").as("component", new String[0]).select("domain", "component").toList();
        String targetRelease = ConfigUtils.getConfigValue("/release", this.config());
        String sourceRelease = ConfigUtils.getConfigValue("/priorRelease", this.config());
        boolean compareRequired = ConfigUtils.isFeatureEnabled("compareReleases", this.config());
        Future updateRepoFuture = this.gitAdapter.prepareSuperRepository().compose(superRepository -> {
            SucceededFuture previousReleaseCopyFuture = SucceededFuture.EMPTY;
            if (compareRequired && sourceRelease != null && !sourceRelease.equals(targetRelease)) {
                previousReleaseCopyFuture = this.gitAdapter.switchSuperRepoBranch((Git)superRepository, sourceRelease).compose(r -> this.getFilesList()).compose(list -> Future.join(this.gitFileRetriever.copyFilesFromRepo((Git)superRepository, sourceRelease, (List)list)));
            }
            Future resultFuture = previousReleaseCopyFuture.compose(r -> this.gitAdapter.switchSuperRepoBranch((Git)superRepository, targetRelease)).compose(r -> {
                List<Future<?>> futures = this.gitAdapter.bulkSubmoduleAdd((Git)superRepository, jsonObjectList);
                return Future.join(futures);
            }).compose(r -> this.gitAdapter.gitStatusCheck((Git)superRepository, s -> !CollectionUtils.isEmpty((Collection)s.getAdded()))).compose(r -> {
                if (((Boolean)r).booleanValue()) {
                    return this.gitAdapter.gitCommit((Git)superRepository, "New repositories added");
                }
                return SucceededFuture.EMPTY;
            }).compose(res -> this.gitAdapter.submoduleUpdate((Git)superRepository).onComplete(h -> superRepository.close()));
            return resultFuture;
        });
        return updateRepoFuture;
    }

    private Future<List<Path>> getFilesList() {
        return this.vertx.fileSystem().readFile(ConfigUtils.getConfigFilePath(this.config(), "config", "diffConfig.json").toString()).map(fileContents -> {
            JsonObject jsonResult = new JsonObject(fileContents);
            List filesArray = jsonResult.getJsonArray("files").stream().map(str -> Path.of((String)str, new String[0])).collect(Collectors.toList());
            return filesArray;
        });
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

