/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConversionUtils {
    public static final Pattern BYTES_PATTERN = Pattern.compile("^(\\d+)(\\D+)$");

    public static long convertToBytes(String orig) {
        long result = -1L;
        if (orig == null) {
            return result;
        }
        Matcher matcher = BYTES_PATTERN.matcher(orig.toLowerCase());
        if (matcher.matches()) {
            String number = matcher.group(1);
            String unit = matcher.group(2);
            result = Long.valueOf(number);
            if ("k".equals(unit) || "kb".equals(unit)) {
                result *= 1000L;
            } else if ("m".equals(unit) || "mb".equals(unit)) {
                result = result * 1000L * 1000L;
            } else if ("g".equals(unit) || "gb".equals(unit)) {
                result = result * 1000L * 1000L * 1000L;
            } else if ("mi".equals(unit)) {
                result = result * 1024L * 1024L;
            } else if ("gi".equals(unit)) {
                result = result * 1024L * 1024L * 1024L;
            } else {
                return -1L;
            }
        }
        return result;
    }

    public static Long convertToMillicores(Object cpuLimit) {
        if (cpuLimit instanceof String) {
            if (((String)cpuLimit).contains("m")) {
                return Long.parseLong(((String)cpuLimit).replace("m", ""));
            }
            return Long.parseLong((String)cpuLimit) * 1000L;
        }
        if (cpuLimit instanceof Integer) {
            return (Integer)cpuLimit * 1000;
        }
        return null;
    }
}

