/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import io.vertx.core.json.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.YamlParser;

public class FSUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static String getComponentDirPath(JsonObject component) {
        return component.getString("directoryPath");
    }

    public static String relativePath(JsonObject component, String fileName) {
        Path absPath = Path.of(fileName, new String[0]).toAbsolutePath();
        Path compPath = Path.of(component.getString("directoryPath"), new String[0]).toAbsolutePath();
        String relativePath = compPath.relativize(absPath).toString().replaceAll("\\\\", "/");
        return relativePath;
    }

    public static String getConfigFilePath(JsonObject config, String ... path) {
        Path configFilePath = ConfigUtils.getConfigFilePath(config, path);
        return configFilePath.toString();
    }

    public static void appendFile(String file, String text) throws IOException {
        Files.writeString(Path.of(file, new String[0]), (CharSequence)text, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    public static void createFile(String file, String text) throws IOException {
        Files.writeString(Path.of(file, new String[0]), (CharSequence)text, StandardOpenOption.CREATE);
    }

    public static String readFileAsIs(String path) throws IOException {
        return Files.readString(Paths.get(path, new String[0]));
    }

    public static String readFileSafe(String path) throws IOException {
        return FSUtils.readFileAsIs(path).replaceAll("[^\\n\\r\\t\\p{Print}]", "?");
    }

    public static String getFolder(String fileLocation) {
        return Path.of(fileLocation, new String[0]).getParent().toString();
    }

    public static InputStream openRawUrlStream(Class<?> caller, String location) throws IOException {
        if (location.startsWith("classpath:")) {
            return caller.getResourceAsStream(location.substring("classpath:".length()));
        }
        return new URL(location).openStream();
    }

    public static synchronized Object getYamlFileContents(Class<?> caller, String location, YamlParser parser) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(FSUtils.openUrlStream(caller, location), JsonUtils.UTF_8);){
            List<Object> data = parser.parseYaml(reader, "yaml-parser/spring.yml");
            parser.fixSpringYamlModel(data);
            List<Object> list = data;
            return list;
        }
    }

    public static InputStream openUrlStream(Class<?> caller, String location) throws IOException {
        InputStream is = FSUtils.openRawUrlStream(caller, location);
        if (is == null) {
            return null;
        }
        if (location.endsWith(".gz")) {
            return new GZIPInputStream(is, 8192);
        }
        if (is instanceof BufferedInputStream) {
            return is;
        }
        return new BufferedInputStream(is, 8192);
    }

    public static OutputStream createFileOutputStream(Path path, OpenOption ... options) throws IOException {
        String fileName = path.getFileName().toString();
        OutputStream fos = null;
        try {
            fos = Files.newOutputStream(path, options);
            if (fileName.endsWith(".gz")) {
                return new GZIPOutputStream(fos, 8192);
            }
            return new BufferedOutputStream(fos, 8192);
        }
        catch (IOException e) {
            if (fos != null) {
                fos.close();
            }
            throw e;
        }
    }
}

