/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.itool.modules.graph.FalloutDto;
import org.qubership.itool.modules.graph.GraphDataConstants;
import org.qubership.itool.modules.processor.GraphMetaInfoSupport;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.JsonArrayDeserializer;
import org.qubership.itool.utils.JsonObjectDeserializer;
import org.qubership.itool.utils.YamlParser;

public class JsonUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final ObjectMapper mapper = DatabindCodec.mapper().copy();
    private static final ObjectMapper prettyMapper = DatabindCodec.mapper().copy();

    public static ObjectMapper mapper() {
        return mapper;
    }

    public static ObjectMapper prettyMapper() {
        return prettyMapper;
    }

    public static List<FalloutDto> getFalloutReportFromDump(JsonObject dump) {
        return GraphMetaInfoSupport.getFalloutReportFromDump(dump);
    }

    public static JsonObject readJsonFile(String path) throws IOException {
        return JsonUtils.readJsonResource(JsonUtils.class, "file:" + path);
    }

    public static <T> T readJsonFile(String path, Class<T> dataType) throws IOException {
        return JsonUtils.readJsonResource(JsonUtils.class, "file:" + path, dataType);
    }

    public static JsonObject readJsonResource(Class<?> caller, String location) throws IOException {
        return JsonUtils.readJsonResource(caller, location, JsonObject.class);
    }

    public static <T> T readJsonResource(Class<?> caller, String location, Class<T> dataType) throws IOException {
        try (InputStream fis = FSUtils.openUrlStream(caller, location);){
            if (fis == null) {
                T t = null;
                return t;
            }
            InputStreamReader reader = new InputStreamReader(fis, UTF_8);
            Object object = mapper.readValue((Reader)reader, dataType);
            return (T)object;
        }
    }

    public static JsonObject bytesToJsonObject(byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)is, UTF_8);
        return (JsonObject)mapper.readValue((Reader)reader, JsonObject.class);
    }

    public static JsonObject gzipBytesToJsonObject(byte[] bytes) throws IOException {
        GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(bytes));
        InputStreamReader reader = new InputStreamReader((InputStream)is, UTF_8);
        return (JsonObject)mapper.readValue((Reader)reader, JsonObject.class);
    }

    public static byte[] jsonObjectToGzipBytes(JsonObject dump) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonUtils.saveJsonToStream(new GZIPOutputStream(baos), dump, false);
        return baos.toByteArray();
    }

    public static JsonObject bufferToJsonObject(Buffer buffer) throws IOException {
        return JsonUtils.readJsonFromBuffer(buffer, JsonObject.class);
    }

    public static JsonObject gzipBufferToJsonObject(Buffer buffer) throws IOException {
        return JsonUtils.readJsonFromGzipBuffer(buffer, JsonObject.class);
    }

    public static <T> T readJsonFromBuffer(Buffer buffer, Class<T> clazz) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(buffer.getBytes());
        InputStreamReader reader = new InputStreamReader((InputStream)is, UTF_8);
        return (T)mapper.readValue((Reader)reader, clazz);
    }

    public static <T> T readJsonFromGzipBuffer(Buffer buffer, Class<T> clazz) throws IOException {
        GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(buffer.getBytes()));
        InputStreamReader reader = new InputStreamReader((InputStream)is, UTF_8);
        return (T)mapper.readValue((Reader)reader, clazz);
    }

    public static void saveJsonToStream(OutputStream out, Object data, boolean pretty) throws IOException {
        ObjectMapper m = pretty ? prettyMapper : mapper;
        try (OutputStreamWriter writer = new OutputStreamWriter(out, UTF_8);){
            m.writeValue((Writer)writer, data);
        }
    }

    public static void saveJson(Path path, Object data, boolean pretty) throws IOException {
        ObjectMapper m = pretty ? prettyMapper : mapper;
        try (OutputStream os = FSUtils.createFileOutputStream(path, new OpenOption[0]);){
            m.writeValue((Writer)new OutputStreamWriter(os, UTF_8), data);
        }
    }

    public static JsonObject getOrCreateJsonObject(JsonObject startFrom, JsonPointer pointer) {
        JsonObject object = (JsonObject)pointer.queryJson((Object)startFrom);
        if (object == null) {
            object = new JsonObject();
            pointer.writeJson((Object)startFrom, (Object)object, true);
        }
        return object;
    }

    public static JsonObject getOrCreateJsonObject(JsonObject parent, String attrName) {
        JsonObject object = parent.getJsonObject(attrName);
        if (object == null) {
            object = new JsonObject();
            parent.put(attrName, (Object)object);
        }
        return object;
    }

    public static JsonArray getOrCreateJsonArray(JsonObject startFrom, JsonPointer pointer) {
        JsonArray array = (JsonArray)pointer.queryJson((Object)startFrom);
        if (array == null) {
            array = new JsonArray();
            pointer.writeJson((Object)startFrom, (Object)array, true);
        }
        return array;
    }

    public static JsonArray getOrCreateJsonArray(JsonObject parent, String attrName) {
        JsonArray array = parent.getJsonArray(attrName);
        if (array == null) {
            array = new JsonArray();
            parent.put(attrName, (Object)array);
        }
        return array;
    }

    public static void copyValueIfNotNull(JsonObject source, JsonObject target, String key) {
        Object value = source.getValue(key);
        if (value != null) {
            target.put(key, value);
        }
    }

    public static void copyValueIfAbsent(JsonObject source, JsonObject target, String key) {
        if (source == null) {
            return;
        }
        Object value = source.getValue(key);
        if (value != null && !target.containsKey(key)) {
            target.put(key, value);
        }
    }

    public static void putValueIfNotNull(JsonObject obj, String key, Object value) {
        if (value != null) {
            obj.put(key, value);
        }
    }

    public static JsonObject yamlToJson(String yaml, String sourceId) throws IOException {
        List<Object> sections = new YamlParser().parseYamlData(yaml, sourceId);
        if (CollectionUtils.isEmpty(sections)) {
            return null;
        }
        return new JsonObject((Map)sections.get(0));
    }

    public static String convertListToString(Object value) {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        if (value instanceof JsonArray) {
            value = ((JsonArray)value).getList();
        }
        if (value instanceof List) {
            return ((List)value).stream().map(String::valueOf).collect(Collectors.joining(", "));
        }
        return value.toString();
    }

    public static String convertListToFilteredString(Object value) {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        if (value instanceof JsonArray) {
            value = ((JsonArray)value).getList();
        }
        if (value instanceof List) {
            return ((List)value).stream().map(String::valueOf).filter(s -> !GraphDataConstants.NOS_TO_RECOGNIZE.contains(s)).collect(Collectors.joining(", "));
        }
        return value.toString();
    }

    public static JsonObject asJsonObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonObject) {
            return (JsonObject)value;
        }
        if (value instanceof Map) {
            return new JsonObject((Map)value);
        }
        throw new ClassCastException("Cannot represent " + value.getClass().getName() + " as " + JsonObject.class.getName());
    }

    public static <K, V> Map<K, V> asMap(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        if (value instanceof JsonObject) {
            return ((JsonObject)value).getMap();
        }
        throw new ClassCastException("Cannot represent " + value.getClass().getName() + " as " + Map.class.getName());
    }

    public static <K> List<K> asList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).getList();
        }
        throw new ClassCastException("Cannot represent " + value.getClass().getName() + " as " + List.class.getName());
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(JsonObject.class, (JsonDeserializer)new JsonObjectDeserializer());
        module.addDeserializer(JsonArray.class, (JsonDeserializer)new JsonArrayDeserializer());
        mapper.registerModule((Module)module);
        prettyMapper.enable(SerializationFeature.INDENT_OUTPUT);
        prettyMapper.registerModule((Module)module);
    }
}

