/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import io.vertx.core.buffer.Buffer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XmlParser {
    protected static final Logger LOGGER = LoggerFactory.getLogger(XmlParser.class);
    static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static Document parseXmlFile(String fileName) throws Exception {
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));){
            Document document = builder.parse(is, fileName);
            return document;
        }
    }

    public static Document parseXmlString(String xmlData, String inputId) throws Exception {
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource source = new InputSource(new StringReader(xmlData));
        source.setSystemId(inputId);
        return builder.parse(source);
    }

    public static Document parseXmlData(InputStream is, String inputId) throws Exception {
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(is, inputId);
    }

    public static Document parseXmlData(byte[] bytes, String inputId) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        return XmlParser.parseXmlData(is, inputId);
    }

    public static Document parseXmlData(Buffer buffer, String inputId) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(buffer.getBytes());
        return XmlParser.parseXmlData(is, inputId);
    }
}

