/*
 * Decompiled with CFR 0.152.
 */
package org.quelea.planningcenter.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lombok.Generated;

public class AccessToken {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="expires_in")
    private long expiresInSeconds;
    @JsonProperty(value="created_at")
    private long createdAt;

    public boolean isTokenValid() {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC).plusSeconds(this.getExpiresInSeconds() - 30L).isAfter(LocalDateTime.now());
    }

    @Generated
    public AccessToken() {
    }

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public long getExpiresInSeconds() {
        return this.expiresInSeconds;
    }

    @Generated
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public void setExpiresInSeconds(long expiresInSeconds) {
        this.expiresInSeconds = expiresInSeconds;
    }

    @Generated
    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessToken)) {
            return false;
        }
        AccessToken other = (AccessToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiresInSeconds() != other.getExpiresInSeconds()) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        return !(this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccessToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expiresInSeconds = this.getExpiresInSeconds();
        result = result * 59 + (int)($expiresInSeconds >>> 32 ^ $expiresInSeconds);
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccessToken(accessToken=" + this.getAccessToken() + ", expiresInSeconds=" + this.getExpiresInSeconds() + ", createdAt=" + this.getCreatedAt() + ")";
    }
}

