/*
 * Decompiled with CFR 0.152.
 */
package org.quelea.planningcenter.auth;

import java.util.Optional;
import lombok.Generated;
import org.quelea.planningcenter.auth.ClientDetails;
import org.quelea.planningcenter.auth.RefreshToken;
import org.quelea.planningcenter.auth.RefreshTokenUpdater;
import org.quelea.planningcenter.auth.TokenClient;

public class AuthToken {
    private static final TokenClient TOKEN_CLIENT = new TokenClient();
    private final ClientDetails clientDetails;
    private RefreshToken token;
    private RefreshTokenUpdater refreshTokenUpdater;

    public AuthToken(ClientDetails clientDetails, RefreshToken token) {
        this.clientDetails = clientDetails;
        this.token = token;
    }

    public AuthToken(ClientDetails clientDetails, String refreshToken) {
        this.clientDetails = clientDetails;
        this.token = new RefreshToken(refreshToken);
    }

    public Optional<String> getCurrentAccessToken() {
        if (!this.token.toAccessToken().isTokenValid()) {
            this.token = TOKEN_CLIENT.getNewRefreshToken(this.clientDetails, this.token);
            if (this.refreshTokenUpdater != null && this.token.getRefreshToken() != null) {
                this.refreshTokenUpdater.tokenUpdated(this.token.getRefreshToken());
            }
        }
        return Optional.ofNullable(this.token.getAccessToken());
    }

    public String getCurrentRefreshToken() {
        return this.token.getRefreshToken();
    }

    @Generated
    public AuthToken(ClientDetails clientDetails, RefreshToken token, RefreshTokenUpdater refreshTokenUpdater) {
        this.clientDetails = clientDetails;
        this.token = token;
        this.refreshTokenUpdater = refreshTokenUpdater;
    }

    @Generated
    public AuthToken withRefreshTokenUpdater(RefreshTokenUpdater refreshTokenUpdater) {
        return this.refreshTokenUpdater == refreshTokenUpdater ? this : new AuthToken(this.clientDetails, this.token, refreshTokenUpdater);
    }
}

