/*
 * Decompiled with CFR 0.152.
 */
package org.quelea.planningcenter.auth;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;

public class LocalCodeServer {
    private static final String OUTPUT = "<html><head><script>window.close();</script></head><body>You may close this window now.</body></html>";
    private static final String OUTPUT_HEADERS = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nContent-Length: ";
    private static final String OUTPUT_END_OF_HEADERS = "\r\n\r\n";
    private final int portNumber;

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<String> getCode(Duration timeout, Runnable afterServerStarted) {
        try (AsynchronousServerSocketChannel serverChannel = AsynchronousServerSocketChannel.open();){
            Optional<String> optional;
            block21: {
                AsynchronousSocketChannel clientChannel;
                block19: {
                    Optional<String> optional2;
                    block20: {
                        serverChannel.bind(new InetSocketAddress("127.0.0.1", this.portNumber));
                        if (afterServerStarted != null) {
                            afterServerStarted.run();
                        }
                        clientChannel = serverChannel.accept().get(timeout.toNanos(), TimeUnit.NANOSECONDS);
                        try {
                            StringBuilder headers = new StringBuilder();
                            while (clientChannel.isOpen() && headers.indexOf(OUTPUT_END_OF_HEADERS) < 0 && headers.indexOf("\n\n") < 0) {
                                ByteBuffer buffer = ByteBuffer.allocate(32);
                                Future<Integer> readResult = clientChannel.read(buffer);
                                readResult.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
                                headers.append(new String(buffer.array()));
                            }
                            String firstLine = headers.toString().split("\n")[0].trim();
                            byte[] toWrite = (OUTPUT_HEADERS + OUTPUT.length() + OUTPUT_END_OF_HEADERS + OUTPUT).getBytes();
                            ByteBuffer toWriteBuffer = ByteBuffer.wrap(toWrite);
                            clientChannel.write(toWriteBuffer).get();
                            if (!firstLine.contains("?code=")) break block19;
                            optional2 = Optional.of(firstLine.substring(firstLine.indexOf("?code=") + 6, firstLine.lastIndexOf(32)));
                            if (clientChannel == null) break block20;
                        }
                        catch (Throwable throwable) {
                            if (clientChannel != null) {
                                try {
                                    clientChannel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        clientChannel.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (clientChannel == null) break block21;
                clientChannel.close();
            }
            return optional;
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            return Optional.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Generated
    public LocalCodeServer(int portNumber) {
        this.portNumber = portNumber;
    }
}

