/*
 * Decompiled with CFR 0.152.
 */
package org.quelea.planningcenter.auth;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.quelea.planningcenter.auth.AuthToken;
import org.quelea.planningcenter.auth.ClientDetails;
import org.quelea.planningcenter.auth.LocalCodeServer;
import org.quelea.planningcenter.auth.RedirectUrlCallback;
import org.quelea.planningcenter.auth.RefreshToken;
import org.quelea.planningcenter.auth.TokenClient;

public class OAuthRedirectFlow {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final TokenClient TOKEN_CLIENT = new TokenClient();
    private final String base;
    private final ClientDetails clientDetails;
    private final String redirect;

    public String getBrowserRedirectUrl() {
        return this.base + "oauth/authorize?client_id=" + this.clientDetails.getClientId() + "&redirect_uri=" + this.redirect + "&response_type=code&scope=services";
    }

    public Optional<AuthToken> listenLocally(Duration timeout, RedirectUrlCallback callback) {
        return new LocalCodeServer(URI.create(this.redirect).getPort()).getCode(timeout, () -> callback.browseToUrl(this.getBrowserRedirectUrl())).map(c -> TOKEN_CLIENT.getNewRefreshToken(this.clientDetails, this.redirect, (String)c)).map(t -> new AuthToken(this.clientDetails, (RefreshToken)t));
    }

    @Generated
    private static String $default$base() {
        return "https://api.planningcenteronline.com/";
    }

    @Generated
    OAuthRedirectFlow(String base, ClientDetails clientDetails, String redirect) {
        this.base = base;
        this.clientDetails = clientDetails;
        this.redirect = redirect;
    }

    @Generated
    public static OAuthRedirectFlowBuilder builder() {
        return new OAuthRedirectFlowBuilder();
    }

    @Generated
    public static class OAuthRedirectFlowBuilder {
        @Generated
        private boolean base$set;
        @Generated
        private String base$value;
        @Generated
        private ClientDetails clientDetails;
        @Generated
        private String redirect;

        @Generated
        OAuthRedirectFlowBuilder() {
        }

        @Generated
        public OAuthRedirectFlowBuilder base(String base) {
            this.base$value = base;
            this.base$set = true;
            return this;
        }

        @Generated
        public OAuthRedirectFlowBuilder clientDetails(ClientDetails clientDetails) {
            this.clientDetails = clientDetails;
            return this;
        }

        @Generated
        public OAuthRedirectFlowBuilder redirect(String redirect) {
            this.redirect = redirect;
            return this;
        }

        @Generated
        public OAuthRedirectFlow build() {
            String base$value = this.base$value;
            if (!this.base$set) {
                base$value = OAuthRedirectFlow.$default$base();
            }
            return new OAuthRedirectFlow(base$value, this.clientDetails, this.redirect);
        }

        @Generated
        public String toString() {
            return "OAuthRedirectFlow.OAuthRedirectFlowBuilder(base$value=" + this.base$value + ", clientDetails=" + this.clientDetails + ", redirect=" + this.redirect + ")";
        }
    }
}

