/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.util.List;
import models.Guestbook;
import org.juckula.JuckulaCompositionTemplate;
import org.ninjax.core.Request;
import org.ninjax.core.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import services.GuestbooksService;
import views.GuestbookPage;

public class GuestbookController {
    private static final Logger logger = LoggerFactory.getLogger(GuestbookController.class);
    private final GuestbooksService guestbooksService;

    public GuestbookController(GuestbooksService guestbooksService) {
        this.guestbooksService = guestbooksService;
    }

    public Result index(Request request) {
        List<Guestbook> guestBookEntries = this.guestbooksService.listGuestBookEntries();
        JuckulaCompositionTemplate guestbookPage = GuestbookPage.render(guestBookEntries);
        return Result.ok().html(guestbookPage.toString());
    }

    public Result post(Request request) {
        String email = request.getParameter("email").orElseThrow();
        String content = request.getParameter("content").orElseThrow();
        Guestbook guestbook = new Guestbook(email, content);
        this.guestbooksService.createGuestbook(guestbook);
        return Result.redirect("/");
    }
}

