/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ninjax.core.NinjaFilter;
import org.ninjax.core.Request;
import org.ninjax.core.Result;
import org.ninjax.core.RouteParameter;

public class Router {
    private final List<Route> routes = new ArrayList<Route>();

    public RouteTmp GET(String path) {
        return new RouteTmp("GET", path);
    }

    public RouteTmp POST(String path) {
        return new RouteTmp("POST", path);
    }

    protected List<Route> getRoutes() {
        return this.routes;
    }

    public class RouteTmp {
        private final String httpMethod;
        private final String path;
        private final List<NinjaFilter> filters = new ArrayList<NinjaFilter>();

        public RouteTmp(String httpMethod, String path) {
            this.httpMethod = httpMethod;
            this.path = path;
        }

        public RouteTmp filter(NinjaFilter ninjaFilter) {
            this.filters.add(ninjaFilter);
            return this;
        }

        public void with(ControllerMethod controllerMethod) {
            Router.this.routes.add(new Route(Router.this, this.httpMethod, this.path, controllerMethod, this.filters));
        }
    }

    public class Route {
        public static final Pattern PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE = Pattern.compile("\\{(.*?)(:\\s(.*?))?\\}");
        private static final String VARIABLE_ROUTES_DEFAULT_REGEX = "([^/]*)";
        private final String httpMethod;
        private final String path;
        private final ControllerMethod controllerMethod;
        private final Pattern pathRegex;
        public final Map<String, RouteParameter> parameters;
        public List<NinjaFilter> filters;

        public Route(Router this$0, String httpMethod, String path, ControllerMethod controllerMethod, List<NinjaFilter> filters) {
            this.httpMethod = httpMethod;
            this.path = path;
            this.controllerMethod = controllerMethod;
            this.pathRegex = Pattern.compile(Route.convertRawUriToRegex(path));
            this.parameters = RouteParameter.parse(path);
            this.filters = filters;
        }

        public Pattern pathRegex() {
            return this.pathRegex;
        }

        public ControllerMethod controllerMethod() {
            return this.controllerMethod;
        }

        public String path() {
            return this.path;
        }

        public String httpMethod() {
            return this.httpMethod;
        }

        private static String convertRawUriToRegex(String rawUri) {
            Matcher groupMatcher = Pattern.compile("\\(([^?].*)\\)").matcher(rawUri);
            String converted = groupMatcher.replaceAll("\\(?:$1\\)");
            Matcher matcher = PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE.matcher(converted);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String namedVariablePartOfRoute = matcher.group(3);
                Object namedVariablePartOfORouteReplacedWithRegex = namedVariablePartOfRoute != null ? "(" + Matcher.quoteReplacement(namedVariablePartOfRoute) + ")" : VARIABLE_ROUTES_DEFAULT_REGEX;
                matcher.appendReplacement(stringBuffer, (String)namedVariablePartOfORouteReplacedWithRegex);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
    }

    public static interface ControllerMethod {
        public Result executeMethod(Request var1);
    }
}

