/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.db.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.ninjax.db.jdbc.NinjaDatasource;
import org.ninjax.db.jdbc.NinjaDatasources;
import org.ninjax.db.jdbc.NinjaDatasourcesProperties;

public class NinjaDbHikariProvider {
    private final NinjaDatasourcesProperties ninjaDatasourceConfigs;
    private List<NinjaDatasource> ninjaDatasources;

    public NinjaDbHikariProvider(NinjaDatasourcesProperties ninjaDatasourceConfigs) {
        this.ninjaDatasourceConfigs = ninjaDatasourceConfigs;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (NinjaDatasource ninjaDatasource : this.ninjaDatasources) {
                HikariDataSource hikariDataSource = (HikariDataSource)ninjaDatasource.getDataSource();
                hikariDataSource.close();
            }
        }));
    }

    public NinjaDatasources get() {
        List<NinjaDatasource> ninjaDatasources = this.ninjaDatasourceConfigs.getDatasources().stream().map(ninjaDatasourceConfig -> {
            Properties properties = this.extractHikariProperties(ninjaDatasourceConfig.getProperties());
            HikariConfig config = new HikariConfig(properties);
            config.setDriverClassName(ninjaDatasourceConfig.getDriver());
            config.setJdbcUrl(ninjaDatasourceConfig.getJdbcUrl());
            config.setUsername(ninjaDatasourceConfig.getUsername());
            config.setPassword(ninjaDatasourceConfig.getPassword());
            HikariDataSource hikariDataSource = new HikariDataSource(config);
            NinjaDatasource ninjaDatasource = new NinjaDatasource(ninjaDatasourceConfig.getName(), (DataSource)hikariDataSource);
            return ninjaDatasource;
        }).collect(Collectors.toList());
        this.ninjaDatasources = ninjaDatasources;
        return new NinjaDatasources(ninjaDatasources);
    }

    private Properties extractHikariProperties(Map<String, String> allPropertiesOfThisDatasource) {
        Properties properties = new Properties();
        allPropertiesOfThisDatasource.forEach((key, value) -> {
            if (key.startsWith("hikari.")) {
                String newKey = key.split("hikari.")[1];
                properties.put(newKey, value);
            }
        });
        return properties;
    }
}

