/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.core;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.ninjax.core.Request;
import org.ninjax.core.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetsController {
    private static final Logger logger = LoggerFactory.getLogger(AssetsController.class);
    private static final String FILENAME_PATH_PARAM = "fileName";
    private static final String BASE_DIR = "/assets/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result serveStatic(Request request) {
        Optional<String> requestedFileOpt = request.getPathParameter(FILENAME_PATH_PARAM).or(() -> Optional.of(request.getRequestPath()));
        if (requestedFileOpt.isEmpty()) {
            logger.warn("Opsi. Not able to find: {} - based on param {}.", requestedFileOpt, (Object)FILENAME_PATH_PARAM);
            return Result.notFound();
        }
        Path resourcePath = Paths.get(BASE_DIR, requestedFileOpt.get()).normalize();
        if (!resourcePath.startsWith(BASE_DIR)) {
            logger.warn("Wow. That is strange. I got a request for file {} - but I was not able to normalize that path ({}). Looks dangerous. Returning 404. ", (Object)resourcePath.toString(), (Object)requestedFileOpt.get());
            return Result.notFound();
        }
        try (InputStream resourceStream = this.getClass().getResourceAsStream(resourcePath.toString());){
            Result result2;
            if (resourceStream == null) {
                logger.debug("Not able to find resource {}. Returning 404.", (Object)resourcePath.toString());
                Result result3 = Result.notFound();
                return result3;
            }
            String mimeType = URLConnection.guessContentTypeFromName(resourcePath.getFileName().toString());
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            Result result = result2 = Result.ok().contentType(mimeType).stream(outputStream -> {
                try {
                    ByteStreams.copy((InputStream)resourceStream, (OutputStream)outputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException("Opsi. An error occurred while reading resource and sending to user.", e);
                }
            });
            return result;
        }
        catch (IOException ex) {
            logger.error("Error serving resource '{}': {}", (Object)resourcePath, (Object)ex.getMessage());
            return Result.notFound();
        }
    }
}

