/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.util.Optional;
import org.ninjax.core.NinjaSession;
import org.ninjax.core.Request;
import org.ninjax.core.Result;
import org.ninjax.core.properties.NinjaProperties;
import services.BasicService;
import views.LandingPage;

public class BasicController {
    public final BasicService basicService;
    public final NinjaProperties ninjaProperties;

    public BasicController(BasicService basicService, NinjaProperties ninjaProperties) {
        this.basicService = basicService;
        this.ninjaProperties = ninjaProperties;
    }

    public Result sessionTest(Request request) {
        NinjaSession ninjaSession = request.getNinjaSession().orElseThrow();
        Optional<String> time = ninjaSession.get("my-custome-time");
        NinjaSession newNinjaSession = ninjaSession.withValue("my-custome-time", "" + System.currentTimeMillis());
        return Result.ok().withNinjaSession(newNinjaSession).text("ok - time in session is " + String.valueOf(time));
    }

    public Result helloWorld(Request request) {
        String appName = this.ninjaProperties.get("appname").orElseThrow();
        String userName = request.getParameter("user").orElse("default");
        String landingPageHtml = LandingPage.render("Hello World " + userName + " running on " + appName).toString();
        return Result.ok().addHeader("testheader", "testvalue").html(landingPageHtml);
    }

    public Result personJson(Request request) {
        Person person = new Person("a name", 12);
        return Result.ok().json(person);
    }

    public Result parsePerson(Request request) {
        Optional personOpt = request.getJsonBody();
        if (personOpt.isPresent()) {
            return Result.ok().json(personOpt.get());
        }
        return Result.badRequest();
    }

    public record Person(String name, int age) {
    }
}

