/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.db.jdbi;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.ninjax.db.jdbc.NinjaDatasource;
import org.ninjax.db.jdbc.NinjaDatasources;
import org.ninjax.db.jdbi.NinjaJdbi;

public class NinjaJdbiImpl
implements NinjaJdbi {
    final Map<String, Jdbi> nameToDBIMap;

    public NinjaJdbiImpl(NinjaDatasources ninjaDatasources) {
        HashMap<String, Jdbi> map = new HashMap<String, Jdbi>();
        for (NinjaDatasource ninjaDatasource : ninjaDatasources.getDatasources()) {
            Jdbi jdbi = Jdbi.create((DataSource)ninjaDatasource.getDataSource());
            jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
            map.put(ninjaDatasource.getName(), jdbi);
        }
        this.nameToDBIMap = ImmutableMap.copyOf(map);
    }

    @Override
    public Jdbi getJdbi(String datasourceName) {
        return this.nameToDBIMap.get(datasourceName);
    }
}

