/*
 * Decompiled with CFR 0.152.
 */
package org.juckula;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JuckulaTool {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{\\{(.+?)}}");

    public static String replacePlaceholders(String template, Map<String, String> params) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            if (!params.containsKey(key)) {
                throw new IllegalArgumentException("Missing variable for placeholder: " + key);
            }
            String replacement = params.get(key);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String readResourceFile(Class<?> clazz) {
        String string;
        block9: {
            String resourceName = clazz.getSimpleName() + ".html";
            InputStream is = clazz.getResourceAsStream(resourceName);
            try {
                if (is == null) {
                    throw new RuntimeException("Resource not found: " + resourceName);
                }
                string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            is.close();
        }
        return string;
    }
}

