/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.core;

import com.google.common.collect.ImmutableMap;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.SecretKeyBuilder;
import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.ninjax.core.FileItem;
import org.ninjax.core.FilterChain;
import org.ninjax.core.NinjaCookie;
import org.ninjax.core.NinjaSession;
import org.ninjax.core.NinjaSessionConverter;
import org.ninjax.core.Request;
import org.ninjax.core.Result;
import org.ninjax.core.RouteFinder;
import org.ninjax.core.Router;
import org.ninjax.core.properties.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaJetty {
    private static final Logger logger = LoggerFactory.getLogger(NinjaJetty.class);
    public final RouteFinder routeFinder;
    public final NinjaProperties ninjaProperties;
    private final Optional<Long> sessionExpiryTimeInSeconds;
    public static final String NINJA_APPLICATION_SECRET_KEY = "application.secret";
    private final int jettyServerPort;
    private final SecretKey secretKeyForSessionEncryption;
    private static final String NINJA_LOGO = "     _______  .___ _______        ____.  _____\n     \\      \\ |   |\\      \\      |    | /  _  \\\n     /   |   \\|   |/   |   \\     |    |/  /_\\  \\\n    /    |    \\   /    |    \\/\\__|    /    |    \\\n    \\____|__  /___\\____|__  /\\________\\____|__  /\n            \\/            \\/                  \\/\n";

    public NinjaJetty(Router router, NinjaProperties ninjaProperties) throws RuntimeException {
        this.routeFinder = new RouteFinder(router);
        this.ninjaProperties = ninjaProperties;
        this.jettyServerPort = Integer.parseInt(ninjaProperties.get("ninja.port").orElse("8080"));
        String encodedSecret = ninjaProperties.get(NINJA_APPLICATION_SECRET_KEY).orElseThrow(() -> {
            SecretKey key = (SecretKey)((SecretKeyBuilder)Jwts.SIG.HS256.key()).build();
            String secretString = (String)Encoders.BASE64.encode((Object)key.getEncoded());
            logger.error("Key {} is missing in your application.conf.Either add it or use -D{}=... to add it during startup.", (Object)NINJA_APPLICATION_SECRET_KEY, (Object)NINJA_APPLICATION_SECRET_KEY);
            logger.error("I just randomly generated the following key that you could use: {}={}", (Object)NINJA_APPLICATION_SECRET_KEY, (Object)secretString);
            return new RuntimeException(NINJA_LOGO);
        });
        byte[] decodedKey = Base64.getDecoder().decode(encodedSecret);
        this.secretKeyForSessionEncryption = new SecretKeySpec(decodedKey, 0, decodedKey.length, "HmacSHA256");
        this.sessionExpiryTimeInSeconds = ninjaProperties.get("application.session.expire_time_in_seconds").map(v -> Long.valueOf(v));
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public final void start() throws Exception {
        System.out.println(NINJA_LOGO);
        QueuedThreadPool threadPool = new QueuedThreadPool(200, 8);
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(this.jettyServerPort);
        server.addConnector((Connector)connector);
        ServletContextHandler request = new ServletContextHandler(0);
        request.setContextPath("/");
        server.setHandler((Handler)request);
        request.addFilter(new FilterHolder((Filter)new NinjaServletFilter()), "/*", null);
        server.start();
        server.join();
    }

    public class NinjaServletFilter
    implements Filter {
        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, jakarta.servlet.FilterChain fc) throws IOException, ServletException {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            try {
                String httpMethod = httpServletRequest.getMethod();
                String requestURI = httpServletRequest.getRequestURI();
                Optional<Router.Route> routingResult = NinjaJetty.this.routeFinder.getRouteFor(httpMethod, requestURI);
                if (routingResult.isPresent()) {
                    Router.Route route = routingResult.get();
                    List<NinjaCookie> ninjaCookies = httpServletRequest.getCookies() == null ? List.of() : Arrays.stream(httpServletRequest.getCookies()).map(c -> NinjaJettyHelper.convertServletCookieToNinjaCookie(c)).toList();
                    Map<String, List<String>> headers = NinjaJettyHelper.extractHeaders(httpServletRequest);
                    Optional<NinjaCookie> ninjaSessionCookie = ninjaCookies.stream().filter(c -> c.name().equals("NINJA_SESSION")).findFirst();
                    Optional ninjaSessionInRequest = ninjaSessionCookie.map(c -> NinjaSessionConverter.extractSessionFromCookie(c, NinjaJetty.this.secretKeyForSessionEncryption)).orElseGet(() -> Optional.empty());
                    Request.InputStreamGetter inputStreamGetter = () -> {
                        try {
                            return httpServletRequest.getInputStream();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    };
                    Request.FileItemGetter fileItemGetter = fieldName -> {
                        try {
                            Part part = httpServletRequest.getPart(fieldName);
                            if (part != null) {
                                return Optional.of(new FileItem(part.getSubmittedFileName(), part.getContentType(), part.getSize(), part.getInputStream()));
                            }
                        }
                        catch (Exception e) {
                            logger.error("Opsi", (Throwable)e);
                        }
                        return Optional.empty();
                    };
                    if (httpServletRequest.getContentType() != null && httpServletRequest.getContentType().startsWith("multipart/")) {
                        httpServletRequest.setAttribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(System.getProperty("java.io.tmpdir")));
                    }
                    Request.FileItemsGetter fileItemsGetter = fieldName -> {
                        ArrayList<FileItem> result = new ArrayList<FileItem>();
                        try {
                            Collection parts = httpServletRequest.getParts();
                            for (Part part : parts) {
                                if (!part.getName().equals(fieldName)) continue;
                                result.add(new FileItem(part.getSubmittedFileName(), part.getContentType(), part.getSize(), part.getInputStream()));
                            }
                        }
                        catch (Exception e) {
                            logger.error("Opsi", (Throwable)e);
                        }
                        return result;
                    };
                    Request request = new Request(route, requestURI, inputStreamGetter, fileItemGetter, fileItemsGetter, ninjaCookies, (Map<String, Object>)ImmutableMap.of(), headers, httpServletRequest.getParameterMap(), ninjaSessionInRequest, httpServletRequest.getLocale());
                    FilterChain chain = new FilterChain(route.filters, 0, routingResult.get().controllerMethod());
                    Result result = chain.doFilter(request);
                    int status = result.status;
                    String contentType = result.contentType;
                    httpServletResponse.setContentType(contentType);
                    httpServletResponse.setStatus(status);
                    NinjaJettyHelper.setHeadersOnResponse(httpServletResponse, result.headers);
                    Result.NinjaSessionState ninjaSessionState = result.ninjaSessionState;
                    Objects.requireNonNull(ninjaSessionState);
                    Result.NinjaSessionState ninjaSessionState2 = ninjaSessionState;
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Exists.class, Result.Remove.class, Result.UnknownButDontTouch.class}, (Result.NinjaSessionState)ninjaSessionState2, n)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            Result.Exists exists = (Result.Exists)ninjaSessionState2;
                            NinjaSession ninjaSessionForResponse = exists.getSession();
                            NinjaCookie cookie = NinjaSessionConverter.createCookieWithInformationOfNinjaSession(ninjaSessionForResponse, NinjaJetty.this.secretKeyForSessionEncryption, NinjaJetty.this.sessionExpiryTimeInSeconds);
                            httpServletResponse.addCookie(NinjaJettyHelper.convertNinjaCookieToServletCookie(cookie));
                            break;
                        }
                        case 1: {
                            Result.Remove remove = (Result.Remove)ninjaSessionState2;
                            NinjaCookie cookie = NinjaSessionConverter.createCookieToRemoveNinjaSession();
                            httpServletResponse.addCookie(NinjaJettyHelper.convertNinjaCookieToServletCookie(cookie));
                            break;
                        }
                        case 2: {
                            Result.UnknownButDontTouch unknownButDontTouch = (Result.UnknownButDontTouch)ninjaSessionState2;
                        }
                    }
                    for (NinjaCookie ninjaCookie : result.cookies) {
                        httpServletResponse.addCookie(NinjaJettyHelper.convertNinjaCookieToServletCookie(ninjaCookie));
                    }
                    if (result.outputStreamRenderer.isPresent()) {
                        result.outputStreamRenderer.get().streamTo((OutputStream)httpServletResponse.getOutputStream());
                    }
                } else {
                    String text = "Opsi. Not found";
                    int status = 404;
                    String contentType = "text/plain";
                    httpServletResponse.setContentType(contentType);
                    httpServletResponse.setStatus(status);
                    httpServletResponse.getWriter().println(text);
                }
            }
            catch (Throwable t) {
                logger.error("OMG! Something really bad happened. Time to investigate...", t);
                try {
                    String text = "Wow. Something really bad happened. Ask the owner of this server if error persists...";
                    int status = 500;
                    String contentType = "text/plain";
                    httpServletResponse.setContentType(contentType);
                    httpServletResponse.setStatus(status);
                    httpServletResponse.getWriter().println(text);
                }
                catch (Throwable e) {
                    logger.debug("I was not able to send a message via http to the user. That may be expected depending on the error", e);
                }
            }
        }
    }

    public static class NinjaJettyHelper {
        public static NinjaCookie convertServletCookieToNinjaCookie(Cookie cookie) {
            return new NinjaCookie(cookie.getName(), cookie.getValue(), Optional.ofNullable(cookie.getComment()), Optional.ofNullable(cookie.getDomain()), cookie.getMaxAge(), Optional.ofNullable(cookie.getPath()), cookie.getSecure(), cookie.isHttpOnly());
        }

        public static Cookie convertNinjaCookieToServletCookie(NinjaCookie ninjaCookie) {
            Cookie cookie = new Cookie(ninjaCookie.name(), ninjaCookie.value());
            ninjaCookie.comment().ifPresent(c -> cookie.setComment(c));
            ninjaCookie.domain().ifPresent(d -> cookie.setDomain(d));
            cookie.setMaxAge(ninjaCookie.maxAge());
            ninjaCookie.path().ifPresent(p -> cookie.setPath(p));
            cookie.setSecure(ninjaCookie.secure());
            cookie.setHttpOnly(ninjaCookie.httpOnly());
            return cookie;
        }

        public static Map<String, List<String>> extractHeaders(HttpServletRequest httpServletRequest) {
            HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                ArrayList<String> headerValues = new ArrayList<String>();
                Enumeration values = httpServletRequest.getHeaders(headerName);
                while (values.hasMoreElements()) {
                    headerValues.add((String)values.nextElement());
                }
                headersMap.put(headerName, headerValues);
            }
            return headersMap;
        }

        public static void setHeadersOnResponse(HttpServletResponse response, Map<String, List<String>> headers) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String headerName = entry.getKey();
                List<String> values = entry.getValue();
                for (String value : values) {
                    response.addHeader(headerName, value);
                }
            }
        }
    }
}

