/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.core;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.ninjax.core.properties.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaMesssages {
    private static final Logger logger = LoggerFactory.getLogger(NinjaMesssages.class);
    private static final String APPLICATION_LANGUAGES = "application.languages";
    private static final String BASE_NAME = "messages";
    private final Map<Locale, ResourceBundle> bundles;
    private final Locale defaultLocale;

    public NinjaMesssages(NinjaProperties ninjaProperties) {
        List supportedLocales = ninjaProperties.get(APPLICATION_LANGUAGES).map(s -> Arrays.stream(s.split(",")).map(String::trim).filter(e -> !e.isEmpty()).map(l -> Locale.of(l)).toList()).orElseThrow(() -> new RuntimeException("Cannot find key application.languages in your application.conf. Please add a line similar to 'application.languages=en,de'"));
        this.defaultLocale = (Locale)supportedLocales.getFirst();
        HashMap<Locale, ResourceBundle> modifiableBundle = new HashMap<Locale, ResourceBundle>();
        for (Locale locale : supportedLocales) {
            ResourceBundle bundle = ResourceBundle.getBundle(BASE_NAME, locale);
            modifiableBundle.put(locale, bundle);
        }
        if (!modifiableBundle.containsKey(this.defaultLocale)) {
            modifiableBundle.put(this.defaultLocale, ResourceBundle.getBundle(BASE_NAME, this.defaultLocale));
        }
        this.bundles = ImmutableMap.copyOf(modifiableBundle);
    }

    public String getMessage(String key, Locale locale, Object ... params) {
        String pattern;
        ResourceBundle bundle = this.bundles.getOrDefault(locale, this.bundles.get(this.defaultLocale));
        try {
            pattern = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            if (locale != this.defaultLocale) {
                try {
                    pattern = this.bundles.get(this.defaultLocale).getString(key);
                }
                catch (MissingResourceException ex) {
                    logger.warn("Cannot find key in your translation messages file. That's something you should look into.", (Throwable)ex);
                    return key;
                }
            }
            logger.warn("Cannot find key in your translation messages file. That's something you should look into.");
            return key;
        }
        return MessageFormat.format(pattern, params);
    }
}

