/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.core;

import com.google.common.collect.ImmutableMap;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.ninjax.core.NinjaCookie;
import org.ninjax.core.NinjaSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaSessionConverter {
    private static final Logger logger = LoggerFactory.getLogger(NinjaSessionConverter.class);
    public static final String NINJA_SESSION_COOKIE_NAME = "NINJA_SESSION";
    private static final String NINJA_SESSION_PATH = "/";

    public static Optional<NinjaSession> extractSessionFromCookie(NinjaCookie ninjaSessionCookie, SecretKey secretKeyForSessionEncryption) {
        long now = System.currentTimeMillis();
        try {
            Claims claims = (Claims)Jwts.parser().verifyWith(secretKeyForSessionEncryption).build().parseSignedClaims((CharSequence)ninjaSessionCookie.value()).getPayload();
            if (claims.getNotBefore() != null && now < claims.getNotBefore().getTime()) {
                return Optional.empty();
            }
            if (claims.getExpiration() != null && now > claims.getExpiration().getTime()) {
                return Optional.empty();
            }
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (Map.Entry e : claims.entrySet()) {
                mapBuilder.put((Object)((String)e.getKey()), (Object)e.getValue().toString());
            }
            NinjaSession ninjaSession = new NinjaSession((ImmutableMap<String, String>)mapBuilder.build());
            return Optional.of(ninjaSession);
        }
        catch (Exception e) {
            logger.debug("Opsi. Error parsing Ninja Session. I am ignoring this session.", (Throwable)e);
            return Optional.empty();
        }
    }

    public static NinjaCookie createCookieToRemoveNinjaSession() {
        int REMOVE_SESSION_MAX_AGE = 0;
        NinjaCookie cookie = new NinjaCookie(NINJA_SESSION_COOKIE_NAME, "", Optional.empty(), Optional.empty(), REMOVE_SESSION_MAX_AGE, Optional.of(NINJA_SESSION_PATH), false, false);
        return cookie;
    }

    public static NinjaCookie createCookieWithInformationOfNinjaSession(NinjaSession ninjaSession, SecretKey secretKeyForSessionEncryption, Optional<Long> sessionExpiryTimeInSeconds) {
        Instant now = Instant.now();
        Optional<Object> expiryInstant = Optional.empty();
        if (ninjaSession.get("exp").isPresent()) {
            expiryInstant = Optional.of(Instant.ofEpochSecond(Long.parseLong(ninjaSession.get("exp").get())));
        }
        if (expiryInstant.isEmpty() && sessionExpiryTimeInSeconds.isPresent()) {
            expiryInstant = Optional.of(now.plusSeconds(sessionExpiryTimeInSeconds.get()));
        }
        Date nowDate = Date.from(now);
        JwtBuilder jwsBuilder = Jwts.builder().notBefore(nowDate).issuedAt(nowDate);
        expiryInstant.ifPresent(i -> jwsBuilder.expiration(Date.from(i)));
        String jws = jwsBuilder.claims(ninjaSession.keyValueStore()).signWith((Key)secretKeyForSessionEncryption).compact();
        Integer maxAge = expiryInstant.map(i -> (int)Duration.between(now, i).getSeconds()).orElse(0);
        NinjaCookie cookie = new NinjaCookie(NINJA_SESSION_COOKIE_NAME, jws, Optional.empty(), Optional.empty(), maxAge, Optional.of(NINJA_SESSION_PATH), false, false);
        return cookie;
    }
}

