/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import org.ninjax.core.FileItem;
import org.ninjax.core.Json;
import org.ninjax.core.NinjaCookie;
import org.ninjax.core.NinjaSession;
import org.ninjax.core.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request {
    private static final Logger logger = LoggerFactory.getLogger(Request.class);
    private final Router.Route route;
    private final Map<String, String> pathParameters;
    private final String requestPath;
    private final InputStreamGetter inputStreamGetter;
    private final FileItemGetter fileItemGetter;
    private final FileItemsGetter fileItemsGetter;
    private final List<NinjaCookie> ninjaCookies;
    private final Map<String, List<String>> headers;
    private final Map<String, Object> payload;
    private final Optional<NinjaSession> ninjaSession;
    private final Map<String, String[]> parameters;
    private final Locale language;

    public Request(Router.Route route, String requestPath, InputStreamGetter inputStreamGetter, FileItemGetter fileItemGetter, FileItemsGetter fileItemsGetter, List<NinjaCookie> ninjaCookies, Map<String, Object> payload, Map<String, List<String>> headers, Map<String, String[]> parameters, Optional<NinjaSession> ninjaSession, Locale language) {
        this.route = route;
        this.requestPath = requestPath;
        this.pathParameters = this.getPathParametersEncoded(requestPath);
        this.inputStreamGetter = inputStreamGetter;
        this.fileItemGetter = fileItemGetter;
        this.fileItemsGetter = fileItemsGetter;
        this.ninjaCookies = ImmutableList.copyOf(ninjaCookies);
        this.payload = ImmutableMap.copyOf(payload);
        this.headers = ImmutableMap.copyOf(headers);
        this.parameters = ImmutableMap.copyOf(parameters);
        this.ninjaSession = ninjaSession;
        this.language = language;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public List<NinjaCookie> getNinjaCookies() {
        return this.ninjaCookies;
    }

    public <A> Optional<A> getJsonBody() {
        Optional<Object> optional;
        block8: {
            InputStream inputStream = this.inputStreamGetter.get();
            try {
                optional = Optional.of(Json.objectMapper.readValue(inputStream, new TypeReference<A>(this){}));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    logger.error("Opsi", (Throwable)ex);
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }

    public Optional<NinjaSession> getNinjaSession() {
        return this.ninjaSession;
    }

    public Router.Route route() {
        return this.route;
    }

    public Optional<String> getPathParameter(String pathParameterName) {
        return Optional.ofNullable(this.pathParameters.get(pathParameterName)).map(p -> URLDecoder.decode(p, StandardCharsets.UTF_8));
    }

    public ImmutableList<String> getParameter(String parameterName) {
        Object[] value = this.parameters.get(parameterName);
        if (value == null) {
            return ImmutableList.of();
        }
        if (value.length == 0) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])value);
    }

    private Map<String, String> getPathParametersEncoded(String uri) {
        HashMap map = Maps.newHashMap();
        Matcher m = this.route.pathRegex().matcher(uri);
        if (m.matches()) {
            Iterator<String> it = this.route.parameters.keySet().iterator();
            for (int i = 1; i < m.groupCount() + 1; ++i) {
                String parameterName = it.next();
                map.put(parameterName, m.group(i));
            }
        }
        return map;
    }

    public void putPayload(String key, Object o) {
        this.payload.put(key, o);
    }

    public <U> Optional<U> getPayload(String key, Class<U> clazz) {
        Object object = this.payload.get(key);
        if (clazz.isInstance(object)) {
            return Optional.of(clazz.cast(object));
        }
        return Optional.empty();
    }

    public Optional<String> getPayload(String key) {
        Object object = this.payload.get(key);
        if (String.class.isInstance(object)) {
            return Optional.of((String)String.class.cast(object));
        }
        return Optional.empty();
    }

    public List<FileItem> getFiles(String fieldName) {
        return this.fileItemsGetter.getFileItems(fieldName);
    }

    public Optional<FileItem> getFile(String fieldName) {
        return this.fileItemGetter.getFileItem(fieldName);
    }

    public Locale getLocale() {
        return this.language;
    }

    public static interface InputStreamGetter {
        public InputStream get();
    }

    public static interface FileItemGetter {
        public Optional<FileItem> getFileItem(String var1);
    }

    public static interface FileItemsGetter {
        public List<FileItem> getFileItems(String var1);
    }
}

