/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.core;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.ninjax.core.Router;

public class RouteParameter {
    private final int index;
    private final String token;
    private final String name;
    private final String regex;

    public RouteParameter(int index, String token, String name, String regex) {
        this.index = index;
        this.token = token;
        this.name = name;
        this.regex = regex;
    }

    public int getIndex() {
        return this.index;
    }

    public String getToken() {
        return this.token;
    }

    public String getName() {
        return this.name;
    }

    public String getRegex() {
        return this.regex;
    }

    public static Map<String, RouteParameter> parse(String path) {
        LinkedHashMap<String, RouteParameter> params = new LinkedHashMap<String, RouteParameter>();
        Matcher matcher = Router.Route.PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE.matcher(path);
        while (matcher.find()) {
            RouteParameter param = new RouteParameter(matcher.start(0), matcher.group(0), matcher.group(1), matcher.group(3));
            params.put(param.getName(), param);
        }
        return params;
    }
}

