/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.core.properties;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaProperties {
    private static final Logger logger = LoggerFactory.getLogger(NinjaProperties.class);
    private final ImmutableMap<String, String> properties = this.loadProperties();
    private static final String DEFAULT_LOCATION_OF_APPLICATION_CONF = "conf/application.conf";

    public Optional<String> get(String propertyName) {
        return Optional.ofNullable((String)this.properties.get((Object)propertyName));
    }

    public ImmutableMap<String, String> getAllProperties() {
        return this.properties;
    }

    private ImmutableMap loadProperties() {
        Properties properties = new Properties();
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_LOCATION_OF_APPLICATION_CONF);){
            if (inputStream == null) {
                logger.error("Sorry, unable to find conf/application.conf");
            } else {
                properties.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            logger.error("Opsi. Failure loading conf/application.conf", (Throwable)e);
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return ImmutableMap.copyOf((Map)properties);
    }
}

