/*
 * Decompiled with CFR 0.152.
 */
package org.ninjax.db.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ninjax.core.properties.NinjaProperties;
import org.ninjax.db.jdbc.NinjaDatasourceProperties;
import org.ninjax.db.jdbc.NinjaDatasourcesProperties;

public class NinjaDatasourcePropertiesExtractor {
    private final String DATASOURCE_PREFIX = "application.datasource";
    private final String DATASOURCE_URL = "url";
    private final String DATASOURCE_USERNAME = "username";
    private final String DATASOURCE_PASSWORD = "password";
    private final String DATASOURCE_DRIVER = "driver";
    private final String DATASOURCE_MIGRATION_ENABLED = "migration.enabled";
    private final String DATASOURCE_MIGRATION_USERNAME = "migration.username";
    private final String DATASOURCE_MIGRATION_PASSWORD = "migration.password";
    private final NinjaProperties ninjaProperties;

    public NinjaDatasourcePropertiesExtractor(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
    }

    public NinjaDatasourcesProperties get() {
        List<NinjaDatasourceProperties> ninjaDatasourceConfigs = this.getDatasources(this.ninjaProperties);
        return new NinjaDatasourcesProperties(ninjaDatasourceConfigs);
    }

    private List<NinjaDatasourceProperties> getDatasources(NinjaProperties ninjaProperties) {
        ImmutableMap<String, String> properties = ninjaProperties.getAllProperties();
        HashSet<String> datasourceNames = new HashSet<String>();
        for (Map.Entry entrySet : properties.entrySet()) {
            if (!((String)entrySet.getKey()).startsWith("application.datasource") || !((String)entrySet.getKey()).endsWith("url")) continue;
            String withoutPrefix = ((String)entrySet.getKey()).split("application.datasource.")[1];
            String datasourceName = withoutPrefix.split(".url")[0];
            datasourceNames.add(datasourceName);
        }
        ArrayList ninjaDatasources = Lists.newArrayList();
        Iterator iterator = datasourceNames.iterator();
        while (iterator.hasNext()) {
            String datasourceName;
            String name = datasourceName = (String)iterator.next();
            String driver = ninjaProperties.get("application.datasource." + datasourceName + ".driver").orElseThrow();
            String jdbcUrl = ninjaProperties.get("application.datasource." + datasourceName + ".url").orElseThrow();
            String username = ninjaProperties.get("application.datasource." + datasourceName + ".username").orElseThrow();
            String password = ninjaProperties.get("application.datasource." + datasourceName + ".password").orElseThrow();
            Optional<NinjaDatasourceProperties.MigrationConfiguration> migrationConfiguration = this.determineMigrationConfguration(datasourceName, username, password);
            Map<String, String> allProperties = this.getAllPropertiesOfThisDatasource(datasourceName, (Map<String, String>)properties);
            NinjaDatasourceProperties ninjaDatasourceConfig = new NinjaDatasourceProperties(name, driver, jdbcUrl, username, password, migrationConfiguration, allProperties);
            ninjaDatasources.add(ninjaDatasourceConfig);
        }
        return ninjaDatasources;
    }

    private Optional<NinjaDatasourceProperties.MigrationConfiguration> determineMigrationConfguration(String datasourceName, String username, String password) {
        Optional<NinjaDatasourceProperties.MigrationConfiguration> migrationConfiguration;
        boolean migrationEnabled = this.ninjaProperties.get("application.datasource." + datasourceName + ".migration.enabled").map(v -> Boolean.valueOf(v)).orElse(Boolean.FALSE);
        if (migrationEnabled) {
            String migrationUsername = this.ninjaProperties.get("application.datasource." + datasourceName + ".migration.username").orElse(username);
            String migrationPassword = this.ninjaProperties.get("application.datasource." + datasourceName + ".migration.password").orElse(password);
            migrationConfiguration = Optional.of(new NinjaDatasourceProperties.MigrationConfiguration(migrationUsername, migrationPassword));
        } else {
            migrationConfiguration = Optional.empty();
        }
        return migrationConfiguration;
    }

    private Map<String, String> getAllPropertiesOfThisDatasource(String datasourceName, Map<String, String> properties) {
        HashMap theseProperties = new HashMap();
        properties.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            if (key.startsWith("application.datasource." + datasourceName)) {
                String keyWithoutDatasourceNamePrefix = key.split("application.datasource." + datasourceName + ".")[1];
                theseProperties.put(keyWithoutDatasourceNamePrefix, (String)entry.getValue());
            }
        });
        return ImmutableMap.copyOf(theseProperties);
    }
}

