/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.r10r.sqlify.SqlifyException;
import org.r10r.sqlify.resultparser.ResultParser;

public final class Sqlify {
    private final String sql;
    private final ResultParser<?> resultParser;
    private final LinkedHashMap<String, Object> parameterMap;
    private final List<String> parametersInSqlSorted;

    private Sqlify(String sql, ResultParser<?> resultParser, LinkedHashMap<String, Object> parameterMap) {
        this.sql = sql;
        this.resultParser = resultParser;
        this.parameterMap = parameterMap;
        this.parametersInSqlSorted = this.extractNameAndPosition(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeSelect(Connection connection) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sql);){
            Object t;
            ResultSet resultSet = preparedStatement.executeQuery();
            Object obj = t = this.resultParser.parseResultSet(resultSet);
            return (T)obj;
        }
        catch (Exception e) {
            throw new SqlifyException("Ops. Something strange happened", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeUpdate(Connection connection) {
        String convertedPreparedStatement = this.convertIntoPreparedStatement(this.sql);
        try (PreparedStatement preparedStatement = connection.prepareStatement(convertedPreparedStatement);){
            int numberOfChangedLines;
            this.applyParameterMapToPreparedStatement(preparedStatement, this.parameterMap, this.parametersInSqlSorted);
            int n = numberOfChangedLines = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException ex) {
            throw new SqlifyException("Ops. Something strange happened", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeUpdateAndReturnGeneratedKey(Connection connection) {
        String convertedPreparedStatement = this.convertIntoPreparedStatement(this.sql);
        try (PreparedStatement preparedStatement = connection.prepareStatement(convertedPreparedStatement, 1);){
            this.applyParameterMapToPreparedStatement(preparedStatement, this.parameterMap, this.parametersInSqlSorted);
            preparedStatement.executeUpdate();
            ResultSet generatedKeys = preparedStatement.getGeneratedKeys();
            Object obj = this.resultParser.parseResultSet(generatedKeys);
            return (T)obj;
        }
        catch (Exception ex) {
            throw new SqlifyException("Ops. Something strange happened", ex);
        }
    }

    private String convertIntoPreparedStatement(String sqlWithNamedPlaceholers) {
        return sqlWithNamedPlaceholers.replaceAll("\\{.*?\\}", "?");
    }

    private List<String> extractNameAndPosition(String userSpecifiedSql) {
        ArrayList<String> allParametersSorted = new ArrayList<String>();
        Pattern p = Pattern.compile("\\{(.*?)\\}");
        Matcher m = p.matcher(userSpecifiedSql);
        while (m.find()) {
            String name = m.group(1);
            allParametersSorted.add(name);
        }
        return allParametersSorted;
    }

    private PreparedStatement applyParameterMapToPreparedStatement(PreparedStatement preparedStatement, Map<String, Object> parameterMap, List<String> parametersInSqlSorted) {
        try {
            for (int i = 0; i < parametersInSqlSorted.size(); ++i) {
                Object value = parameterMap.get(parametersInSqlSorted.get(i));
                int positionInPreparedStatement = i + 1;
                if (value instanceof BigDecimal) {
                    preparedStatement.setBigDecimal(positionInPreparedStatement, (BigDecimal)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    preparedStatement.setBoolean(positionInPreparedStatement, (Boolean)value);
                    continue;
                }
                if (value instanceof Date) {
                    preparedStatement.setDate(positionInPreparedStatement, (Date)value);
                    continue;
                }
                if (value instanceof Double) {
                    preparedStatement.setDouble(positionInPreparedStatement, (Double)value);
                    continue;
                }
                if (value instanceof Float) {
                    preparedStatement.setFloat(positionInPreparedStatement, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Integer) {
                    preparedStatement.setInt(positionInPreparedStatement, (Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    preparedStatement.setLong(positionInPreparedStatement, (Long)value);
                    continue;
                }
                if (value instanceof Short) {
                    preparedStatement.setShort(positionInPreparedStatement, (Short)value);
                    continue;
                }
                if (value instanceof String) {
                    preparedStatement.setString(positionInPreparedStatement, (String)value);
                    continue;
                }
                if (value instanceof Time) {
                    preparedStatement.setTime(positionInPreparedStatement, (Time)value);
                    continue;
                }
                if (value instanceof Timestamp) {
                    preparedStatement.setTimestamp(positionInPreparedStatement, (Timestamp)value);
                    continue;
                }
                if (value instanceof URL) {
                    preparedStatement.setURL(positionInPreparedStatement, (URL)value);
                    continue;
                }
                preparedStatement.setObject(positionInPreparedStatement, value);
            }
        }
        catch (SQLException ex) {
            throw new SqlifyException("Ops. An error occurred.", ex);
        }
        return preparedStatement;
    }

    public static Builder1 sql(String sql) {
        return new Builder1(sql);
    }

    public static class Builder1 {
        private final String sql;
        private final LinkedHashMap<String, Object> parameterMap;
        private ResultParser<?> resultParser;

        public Builder1(String sql) {
            this.sql = sql;
            this.parameterMap = new LinkedHashMap();
        }

        public Builder1 withParameter(String key, Object value) {
            this.parameterMap.put(key, value);
            return this;
        }

        public Builder1 parseResultWith(ResultParser<?> resultParser) {
            this.resultParser = resultParser;
            return this;
        }

        public <E> E executeSelect(Connection connection) {
            Sqlify sqlify = new Sqlify(this.sql, this.resultParser, this.parameterMap);
            return (E)sqlify.executeSelect(connection);
        }

        public int executeUpdate(Connection connection) {
            Sqlify sqlify = new Sqlify(this.sql, this.resultParser, this.parameterMap);
            return sqlify.executeUpdate(connection);
        }

        public <E> E executeUpdateAndReturnGeneratedKey(Connection connection) {
            Sqlify sqlify = new Sqlify(this.sql, this.resultParser, this.parameterMap);
            return (E)sqlify.executeUpdateAndReturnGeneratedKey(connection);
        }
    }
}

