/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify.rowparser;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import org.r10r.sqlify.SqlifyException;
import org.r10r.sqlify.rowparser.RowParser;

public class PojoRowParser<E>
implements RowParser<E> {
    private final Class<E> clazz;

    PojoRowParser(Class<E> clazz) {
        this.clazz = clazz;
    }

    @Override
    public E parse(ResultSet resultSet) throws Exception {
        E e = this.clazz.newInstance();
        for (Field field : e.getClass().getDeclaredFields()) {
            Object value;
            String name = field.getName();
            Class<?> type = field.getType();
            boolean initialFieldAccessibility = field.isAccessible();
            field.setAccessible(true);
            if (type == BigDecimal.class) {
                value = resultSet.getBigDecimal(name);
                field.set(e, value);
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                value = resultSet.getBoolean(name);
                field.set(e, value);
            } else if (type == Date.class) {
                value = resultSet.getDate(name);
                field.set(e, value);
            } else if (type == Double.class || type == Double.TYPE) {
                value = resultSet.getDouble(name);
                field.set(e, value);
            } else if (type == Float.class || type == Float.TYPE) {
                value = Float.valueOf(resultSet.getFloat(name));
                field.set(e, value);
            } else if (type == Integer.class || type == Integer.TYPE) {
                value = resultSet.getInt(name);
                field.set(e, value);
            } else if (type == Long.class || type == Long.TYPE) {
                value = resultSet.getLong(name);
                field.set(e, value);
            } else if (type == Short.class || type == Short.TYPE) {
                value = resultSet.getShort(name);
                field.set(e, value);
            } else if (type == String.class) {
                value = resultSet.getString(name);
                field.set(e, value);
            } else if (type == Time.class) {
                value = resultSet.getTime(name);
                field.set(e, value);
            } else if (type == Timestamp.class) {
                value = resultSet.getTimestamp(name);
                field.set(e, value);
            } else if (type == URL.class) {
                value = resultSet.getURL(name);
                field.set(e, value);
            } else {
                throw new SqlifyException("Ops. not supported... " + field.getName() + " -- " + field.getType());
            }
            field.setAccessible(initialFieldAccessibility);
        }
        return e;
    }
}

