/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify.rowparser;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import org.r10r.sqlify.SqlifyException;
import org.r10r.sqlify.rowparser.RowParser;

public class PojoRowParser<E>
implements RowParser<E> {
    private final Class<E> clazz;

    PojoRowParser(Class<E> clazz) {
        this.clazz = clazz;
    }

    @Override
    public E parse(ResultSet resultSet) throws Exception {
        E e = this.clazz.newInstance();
        for (Field field : e.getClass().getDeclaredFields()) {
            String name = field.getName();
            Class<?> type = field.getType();
            boolean initialFieldAccessibility = field.isAccessible();
            field.setAccessible(true);
            if (type == String.class) {
                String value = resultSet.getString(name);
                field.set(e, value);
            } else if (type == Integer.class || type == Integer.TYPE) {
                Integer value = resultSet.getInt(name);
                field.set(e, value);
            } else if (type == Long.class || type == Long.TYPE) {
                Long value = resultSet.getLong(name);
                field.set(e, value);
            } else if (type == Double.class || type == Double.TYPE) {
                Double value = resultSet.getDouble(name);
                field.set(e, value);
            } else if (type == Float.class || type == Float.TYPE) {
                Float value = Float.valueOf(resultSet.getFloat(name));
                field.set(e, value);
            } else if (type == Short.class || type == Short.TYPE) {
                Short value = resultSet.getShort(name);
                field.set(e, value);
            } else if (type == Byte.TYPE) {
                byte value = resultSet.getByte(name);
                field.set(e, value);
            } else if (type == byte[].class) {
                byte[] value = resultSet.getBytes(name);
                field.set(e, value);
            } else if (type == BigDecimal.class) {
                BigDecimal value = resultSet.getBigDecimal(name);
                field.set(e, value);
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                Boolean value = resultSet.getBoolean(name);
                field.set(e, value);
            } else if (type == Date.class) {
                Date value = resultSet.getDate(name);
                field.set(e, value);
            } else if (type == Time.class) {
                Time value = resultSet.getTime(name);
                field.set(e, value);
            } else if (type == Timestamp.class) {
                Timestamp value = resultSet.getTimestamp(name);
                field.set(e, value);
            } else if (type == URL.class) {
                URL value = resultSet.getURL(name);
                field.set(e, value);
            } else {
                throw new SqlifyException("Ops. not supported... " + field.getName() + " -- " + field.getType());
            }
            field.setAccessible(initialFieldAccessibility);
        }
        return e;
    }
}

