/*
 * Decompiled with CFR 0.152.
 */
package org.raml.pojotoraml.types;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.raml.builder.NodeBuilder;
import org.raml.builder.PropertyValueBuilder;
import org.raml.builder.TypeBuilder;
import org.raml.pojotoraml.types.RamlType;

public enum ScalarType implements RamlType
{
    NUMBER("number", (Map<Class<?>, String>)new ImmutableMap.Builder().put(Float.TYPE, (Object)"float").put(Float.class, (Object)"float").put(Double.TYPE, (Object)"double").put(Double.class, (Object)"double").build()),
    FILE("file", (Map<Class<?>, String>)new ImmutableMap.Builder().build()),
    BOOLEAN("boolean", (Map<Class<?>, String>)new ImmutableMap.Builder().build()),
    STRING("string", (Map<Class<?>, String>)new ImmutableMap.Builder().build()),
    DATE_ONLY("date-only", (Map<Class<?>, String>)new ImmutableMap.Builder().build()),
    TIME_ONLY("time-only", (Map<Class<?>, String>)new ImmutableMap.Builder().build()),
    DATETIME_ONLY("datetime-only", (Map<Class<?>, String>)new ImmutableMap.Builder().build()),
    DATETIME("datetime", (Map<Class<?>, String>)new ImmutableMap.Builder().build()),
    INTEGER("integer", (Map<Class<?>, String>)new ImmutableMap.Builder().put(Integer.TYPE, (Object)"int32").put(Integer.class, (Object)"int32").put(Short.TYPE, (Object)"int16").put(Short.class, (Object)"int16").put(Byte.TYPE, (Object)"int8").put(Byte.class, (Object)"int8").put(Long.TYPE, (Object)"int64").put(Long.class, (Object)"int64").build()),
    NIL("nil", (Map<Class<?>, String>)new ImmutableMap.Builder().build());

    private static final Map<Type, ScalarType> JAVA_TO_RAML_TYPES;
    private static final Set<String> SCALAR_TYPES;
    private final String ramlSyntax;
    private final Map<Class<?>, String> formats;

    private ScalarType(String ramlSyntax, Map<Class<?>, String> formats) {
        this.ramlSyntax = ramlSyntax;
        this.formats = formats;
    }

    @Override
    public TypeBuilder getRamlSyntax() {
        return TypeBuilder.type((String)this.ramlSyntax);
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public Class<?> type() {
        return null;
    }

    public static Optional<RamlType> fromType(final Type type) {
        final ScalarType foundType = JAVA_TO_RAML_TYPES.get(type);
        if (foundType == null) {
            return Optional.absent();
        }
        RamlType wrappedType = new RamlType(){

            @Override
            public TypeBuilder getRamlSyntax() {
                String format = (String)foundType.formats.get(type);
                if (format == null) {
                    return foundType.getRamlSyntax();
                }
                return (TypeBuilder)foundType.getRamlSyntax().with(new NodeBuilder[]{PropertyValueBuilder.property((String)"format", (String)format)});
            }

            @Override
            public boolean isScalar() {
                return true;
            }

            @Override
            public boolean isEnum() {
                return false;
            }

            @Override
            public Class<?> type() {
                return (Class)type;
            }
        };
        return Optional.of((Object)wrappedType);
    }

    public static boolean isRamalScalarType(String type) {
        return SCALAR_TYPES.contains(type);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Byte.TYPE, (Object)INTEGER);
        builder.put(Byte.class, (Object)INTEGER);
        builder.put(Short.TYPE, (Object)INTEGER);
        builder.put(Short.class, (Object)INTEGER);
        builder.put(Integer.TYPE, (Object)INTEGER);
        builder.put(Integer.class, (Object)INTEGER);
        builder.put(Long.TYPE, (Object)INTEGER);
        builder.put(Long.class, (Object)INTEGER);
        builder.put(InputStream.class, (Object)FILE);
        builder.put(Date.class, (Object)DATE_ONLY);
        builder.put(String.class, (Object)STRING);
        builder.put(Float.TYPE, (Object)NUMBER);
        builder.put(Float.class, (Object)NUMBER);
        builder.put(Double.TYPE, (Object)NUMBER);
        builder.put(Double.class, (Object)NUMBER);
        builder.put(Boolean.TYPE, (Object)BOOLEAN);
        builder.put(Boolean.class, (Object)BOOLEAN);
        JAVA_TO_RAML_TYPES = builder.build();
        SCALAR_TYPES = new HashSet<String>();
        for (ScalarType scalarType : ScalarType.values()) {
            SCALAR_TYPES.add(scalarType.ramlSyntax);
        }
    }
}

