/*
 * Decompiled with CFR 0.152.
 */
package org.raml.pojotoraml;

import java.lang.reflect.Type;
import java.util.Collection;
import org.raml.builder.TypeBuilder;
import org.raml.builder.TypeDeclarationBuilder;
import org.raml.builder.TypePropertyBuilder;
import org.raml.pojotoraml.Property;

public interface RamlAdjuster {
    public static final RamlAdjuster NULL_ADJUSTER = new Helper();

    public String adjustEnumValue(Class<?> var1, String var2);

    public TypeBuilder adjustType(Type var1, String var2, TypeBuilder var3);

    public String adjustTypeName(Class<?> var1, String var2);

    public TypePropertyBuilder adjustScalarProperty(TypeDeclarationBuilder var1, Property var2, TypePropertyBuilder var3);

    public TypePropertyBuilder adjustComposedProperty(TypeDeclarationBuilder var1, Property var2, TypePropertyBuilder var3);

    public static class Composite
    implements RamlAdjuster {
        private final Collection<RamlAdjuster> adjusters;

        public Composite(Collection<RamlAdjuster> adjusters) {
            this.adjusters = adjusters;
        }

        @Override
        public String adjustEnumValue(Class<?> type, String name) {
            String val = name;
            for (RamlAdjuster adjuster : this.adjusters) {
                val = adjuster.adjustEnumValue(type, val);
            }
            return val;
        }

        @Override
        public TypeBuilder adjustType(Type type, String typeName, TypeBuilder builder) {
            TypeBuilder val = builder;
            for (RamlAdjuster adjuster : this.adjusters) {
                val = adjuster.adjustType(type, typeName, val);
            }
            return val;
        }

        @Override
        public String adjustTypeName(Class<?> aClass, String name) {
            String val = name;
            for (RamlAdjuster adjuster : this.adjusters) {
                val = adjuster.adjustTypeName(aClass, val);
            }
            return val;
        }

        @Override
        public TypePropertyBuilder adjustScalarProperty(TypeDeclarationBuilder typeDeclaration, Property property, TypePropertyBuilder typePropertyBuilder) {
            TypePropertyBuilder val = typePropertyBuilder;
            for (RamlAdjuster adjuster : this.adjusters) {
                val = adjuster.adjustScalarProperty(typeDeclaration, property, val);
            }
            return val;
        }

        @Override
        public TypePropertyBuilder adjustComposedProperty(TypeDeclarationBuilder typeDeclaration, Property property, TypePropertyBuilder typePropertyBuilder) {
            TypePropertyBuilder val = typePropertyBuilder;
            for (RamlAdjuster adjuster : this.adjusters) {
                val = adjuster.adjustComposedProperty(typeDeclaration, property, val);
            }
            return val;
        }
    }

    public static class Helper
    implements RamlAdjuster {
        @Override
        public String adjustEnumValue(Class<?> type, String name) {
            return name;
        }

        @Override
        public TypeBuilder adjustType(Type type, String typeName, TypeBuilder builder) {
            return builder;
        }

        @Override
        public String adjustTypeName(Class<?> aClass, String name) {
            return name;
        }

        @Override
        public TypePropertyBuilder adjustScalarProperty(TypeDeclarationBuilder typeDeclaration, Property property, TypePropertyBuilder typePropertyBuilder) {
            return typePropertyBuilder;
        }

        @Override
        public TypePropertyBuilder adjustComposedProperty(TypeDeclarationBuilder typeDeclaration, Property property, TypePropertyBuilder typePropertyBuilder) {
            return typePropertyBuilder;
        }
    }
}

