/*
 * Decompiled with CFR 0.152.
 */
package org.raml.pojotoraml.util;

import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationFinder {
    private static final Logger logger = LoggerFactory.getLogger((String)"AnnotationFinder");

    public static <T extends Annotation> T annotationFor(Package aPkg, Class<? extends T> whichAnnotation) {
        T annotation = null;
        T t = aPkg.getAnnotation(whichAnnotation);
        annotation = t;
        if (t == null) {
            annotation = AnnotationFinder.find(aPkg, whichAnnotation);
        }
        return annotation;
    }

    private static <T extends Annotation> T find(Package aPkg, Class<? extends T> which) {
        Annotation found = null;
        try {
            String pkgName = aPkg.getName() + ".package-info";
            Class<?> klazz = AnnotationFinder.class.getClassLoader().loadClass(pkgName);
            logger.debug("{} Attempted a reload of class '{}'\n", new Object[]{"******* ", pkgName, " *******"});
            found = (Annotation)aPkg.getAnnotation(which);
            logger.debug("{} After class reload attempt, T: '{} ({})' {}\n", new Object[]{"******* ", found, klazz.getDeclaredAnnotations(), " *******"});
            Annotation[] annotations = new Annotation[]{};
            if (found == null && (annotations = klazz.getDeclaredAnnotations()) != null) {
                found = annotations[0];
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return (T)found;
    }
}

