/*
 * Decompiled with CFR 0.152.
 */
package org.raml.pojotoraml;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.raml.builder.TypeBuilder;
import org.raml.builder.TypeDeclarationBuilder;
import org.raml.builder.TypePropertyBuilder;
import org.raml.pojotoraml.AdjusterFactory;
import org.raml.pojotoraml.ClassParser;
import org.raml.pojotoraml.ClassParserFactory;
import org.raml.pojotoraml.GeneratedRamlType;
import org.raml.pojotoraml.PojoToRaml;
import org.raml.pojotoraml.Property;
import org.raml.pojotoraml.RamlAdjuster;
import org.raml.pojotoraml.Result;
import org.raml.pojotoraml.types.RamlType;
import org.raml.pojotoraml.types.RamlTypeFactory;
import org.raml.pojotoraml.types.ScalarType;

public class PojoToRamlImpl
implements PojoToRaml {
    private final ClassParserFactory classParserFactory;
    private final AdjusterFactory adjusterFactory;

    public PojoToRamlImpl(ClassParserFactory parser, AdjusterFactory adjusterFactory) {
        this.classParserFactory = parser;
        this.adjusterFactory = adjusterFactory;
    }

    @Override
    public Result classToRaml(Class<?> clazz) {
        RamlType type = (RamlType)RamlTypeFactory.forType(clazz, this.classParserFactory.createParser(clazz), this.adjusterFactory).or((Supplier)new RamlTypeSupplier(clazz));
        if (type.isScalar()) {
            return new Result(null, Collections.emptyMap());
        }
        HashMap<String, TypeDeclarationBuilder> dependentTypes = new HashMap<String, TypeDeclarationBuilder>();
        TypeDeclarationBuilder builder = this.handleSingleType(clazz, dependentTypes);
        dependentTypes.remove(builder.id());
        return new Result(builder, dependentTypes);
    }

    @Override
    public TypeBuilder name(Class<?> clazz) {
        RamlAdjuster adjuster = this.adjusterFactory.createAdjuster(clazz);
        ClassParser parser = this.classParserFactory.createParser(clazz);
        RamlType type = (RamlType)RamlTypeFactory.forType(clazz, parser, this.adjusterFactory).or((Supplier)new RamlTypeSupplier(clazz));
        if (type.isScalar()) {
            return type.getRamlSyntax();
        }
        String simpleName = adjuster.adjustTypeName(clazz, clazz.getSimpleName());
        return TypeBuilder.type((String)simpleName);
    }

    @Override
    public TypeBuilder name(Type type) {
        if (type instanceof Class) {
            return this.name((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            if (pt.getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)pt.getRawType()) && pt.getActualTypeArguments().length == 1) {
                Class cls = (Class)pt.getActualTypeArguments()[0];
                TypeBuilder builder = this.name(cls);
                return TypeBuilder.arrayOf((TypeBuilder)builder);
            }
            throw new IllegalArgumentException("can't parse type " + pt);
        }
        throw new IllegalArgumentException("can't parse type " + type);
    }

    private TypeDeclarationBuilder handleSingleType(Class<?> clazz, Map<String, TypeDeclarationBuilder> builtTypes) {
        ClassParser parser = this.classParserFactory.createParser(clazz);
        RamlType quickType = (RamlType)RamlTypeFactory.forType(clazz, parser, this.adjusterFactory).or((Supplier)new RamlTypeSupplier(clazz));
        if (quickType.isScalar()) {
            return TypeDeclarationBuilder.typeDeclaration((String)quickType.getRamlSyntax().id()).ofType(quickType.getRamlSyntax());
        }
        if (quickType.isEnum()) {
            return this.handleEnum(quickType, this.adjusterFactory.createAdjuster(clazz), builtTypes);
        }
        String simpleName = this.adjusterFactory.createAdjuster(clazz).adjustTypeName(clazz, clazz.getSimpleName());
        TypeBuilder builder = this.buildSuperType(clazz, builtTypes);
        builder = this.adjusterFactory.createAdjuster(clazz).adjustType(clazz, simpleName, builder);
        TypeDeclarationBuilder typeDeclaration = TypeDeclarationBuilder.typeDeclaration((String)simpleName).ofType(builder);
        if (!ScalarType.isRamalScalarType(simpleName)) {
            builtTypes.put(simpleName, typeDeclaration);
        }
        for (Property property : parser.properties(clazz)) {
            Optional<RamlType> ramlTypeOptional = RamlTypeFactory.forType(property.type(), parser, this.adjusterFactory);
            if (!ramlTypeOptional.isPresent()) {
                RamlType type = PojoToRamlImpl.resolveUnknownTypeInProperty(this.adjusterFactory, clazz, builder, typeDeclaration, property);
                if (type == null) continue;
                builder.withProperty(new TypePropertyBuilder[]{TypePropertyBuilder.property((String)property.name(), (TypeBuilder)type.getRamlSyntax())});
                continue;
            }
            RamlType ramlType = (RamlType)ramlTypeOptional.get();
            if (ramlType.isScalar()) {
                TypePropertyBuilder typePropertyBuilder = TypePropertyBuilder.property((String)property.name(), (TypeBuilder)ramlType.getRamlSyntax());
                builder.withProperty(new TypePropertyBuilder[]{this.adjusterFactory.createAdjuster(ramlType.type()).adjustScalarProperty(typeDeclaration, property, typePropertyBuilder)});
                continue;
            }
            String subSimpleName = this.adjusterFactory.createAdjuster(clazz).adjustTypeName(clazz, ramlType.type().getSimpleName());
            if (!builtTypes.containsKey(subSimpleName)) {
                this.handleSingleType(ramlType.type(), builtTypes);
            }
            TypePropertyBuilder typePropertyBuilder = TypePropertyBuilder.property((String)property.name(), (TypeBuilder)ramlType.getRamlSyntax());
            builder.withProperty(new TypePropertyBuilder[]{this.adjusterFactory.createAdjuster(ramlType.type()).adjustComposedProperty(typeDeclaration, property, typePropertyBuilder)});
        }
        return typeDeclaration;
    }

    private TypeDeclarationBuilder handleEnum(final RamlType quickType, final RamlAdjuster adjuster, Map<String, TypeDeclarationBuilder> builtTypes) {
        Class<?> c = quickType.type();
        TypeBuilder typeBuilder = TypeBuilder.type().enumValues((String[])FluentIterable.of((Object[])c.getEnumConstants()).transform((Function)new Function<Enum, String>(){

            @Nullable
            public String apply(@Nullable Enum o) {
                return adjuster.adjustEnumValue(quickType.type(), o.name());
            }
        }).toArray(String.class));
        adjuster.adjustType(quickType.type(), quickType.getRamlSyntax().id(), typeBuilder);
        TypeDeclarationBuilder typeDeclarationBuilder = TypeDeclarationBuilder.typeDeclaration((String)quickType.getRamlSyntax().id()).ofType(typeBuilder);
        builtTypes.put(quickType.getRamlSyntax().id(), typeDeclarationBuilder);
        return typeDeclarationBuilder;
    }

    private TypeBuilder buildSuperType(Class<?> clazz, Map<String, TypeDeclarationBuilder> builtTypes) {
        ClassParser parser = this.classParserFactory.createParser(clazz);
        Collection<Type> types = parser.parentClasses(clazz);
        ArrayList<String> typeNames = new ArrayList<String>();
        if (types != null) {
            for (Type supertype : types) {
                if (supertype instanceof Class && ((Class)supertype).getPackage().getName().startsWith("java.")) continue;
                RamlType ramlType = (RamlType)RamlTypeFactory.forType(supertype, parser, this.adjusterFactory).or((Supplier)new RamlTypeSupplier(clazz));
                String subSimpleName = this.adjusterFactory.createAdjuster(ramlType.type()).adjustTypeName(ramlType.type(), ramlType.type().getSimpleName());
                if (!builtTypes.containsKey(subSimpleName)) {
                    this.handleSingleType(ramlType.type(), builtTypes);
                }
                typeNames.add(subSimpleName);
            }
        }
        TypeBuilder builder = typeNames.isEmpty() ? TypeBuilder.type((String)"object") : TypeBuilder.type((String[])typeNames.toArray(new String[0]));
        return builder;
    }

    private static RamlType resolveUnknownTypeInProperty(AdjusterFactory adjusterFactory, Class<?> clazz, TypeBuilder typeBuilder, TypeDeclarationBuilder typeDeclarationBuilder, Property property) {
        TypeBuilder tb = adjusterFactory.createAdjuster(clazz).adjustForUnknownType(property.type());
        if (tb != null) {
            return new GeneratedRamlType(clazz, typeBuilder);
        }
        adjusterFactory.createAdjuster(clazz).adjustForUnknownTypeInProperty(clazz, typeBuilder, typeDeclarationBuilder, property);
        return null;
    }

    private class RamlTypeSupplier
    implements Supplier<RamlType> {
        private final Class<?> clazz;

        public RamlTypeSupplier(Class<?> clazz) {
            this.clazz = clazz;
        }

        public RamlType get() {
            TypeBuilder tb = PojoToRamlImpl.this.adjusterFactory.createAdjuster(this.clazz).adjustForUnknownType(this.clazz);
            return new GeneratedRamlType(this.clazz, tb);
        }
    }
}

