/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo;

import com.google.common.base.Optional;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.EventType;

public class CreationResult {
    private final String packageName;
    private ClassName interfaceName;
    private ClassName implementationName;
    private TypeSpec interf;
    private TypeSpec impl;
    private final Map<String, CreationResult> internalTypes = new HashMap<String, CreationResult>();

    public CreationResult(String packageName, ClassName interfaceName, ClassName implementationName) {
        this.packageName = packageName;
        this.interfaceName = interfaceName;
        this.implementationName = implementationName;
    }

    public CreationResult withInterface(TypeSpec spec) {
        this.interf = spec;
        return this;
    }

    public CreationResult withImplementation(TypeSpec spec) {
        this.impl = spec;
        return this;
    }

    public TypeSpec getInterface() {
        return this.interf;
    }

    public Optional<TypeSpec> getImplementation() {
        return Optional.fromNullable((Object)this.impl);
    }

    public void createType(String rootDirectory) throws IOException {
        if (this.interf.typeSpecs.size() == 0) {
            CreationResult.createInlineType(this);
        }
        this.createJavaFile(this.packageName, this.interf, rootDirectory, true);
        if (this.implementationName != null) {
            this.createJavaFile(this.packageName, this.impl, rootDirectory, false);
        }
    }

    protected void createJavaFile(String packageName, TypeSpec typeSpec, String rootDirectory, boolean interf) throws IOException {
        if (interf) {
            JavaFile.builder((String)this.interfaceName.packageName(), (TypeSpec)typeSpec).skipJavaLangImports(true).build().writeTo(Paths.get(rootDirectory, new String[0]));
        } else if (typeSpec != null) {
            JavaFile.builder((String)this.implementationName.packageName(), (TypeSpec)typeSpec).skipJavaLangImports(true).build().writeTo(Paths.get(rootDirectory, new String[0]));
        }
    }

    private static void createInlineType(CreationResult containingResult) {
        for (CreationResult internalType : containingResult.internalTypes.values()) {
            CreationResult.createInlineType(internalType);
            containingResult.interf = containingResult.getInterface().toBuilder().addType(internalType.getInterface()).build();
            if (containingResult.getImplementation().isPresent()) {
                if (!internalType.getImplementation().isPresent()) continue;
                containingResult.impl = ((TypeSpec)containingResult.getImplementation().get()).toBuilder().addType(((TypeSpec)internalType.getImplementation().get()).toBuilder().addModifiers(new Modifier[]{Modifier.STATIC}).build()).build();
                continue;
            }
            if (!internalType.getImplementation().isPresent()) continue;
            containingResult.interf = containingResult.getInterface().toBuilder().addType((TypeSpec)internalType.getImplementation().get()).build();
        }
    }

    public CreationResult getInternalTypeForProperty(String inside) {
        return this.internalTypes.get(inside);
    }

    public ClassName getJavaName(EventType eventType) {
        if (eventType == EventType.IMPLEMENTATION) {
            return this.implementationName;
        }
        return this.interfaceName;
    }

    public CreationResult withInternalType(String name, CreationResult internal) {
        this.internalTypes.put(name, internal);
        return this;
    }

    public CreationResult internalType(String name) {
        return this.internalTypes.get(name);
    }
}

