/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.jackson1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.annotate.JsonTypeName;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class JacksonBasicExtension
extends ObjectTypeHandlerPlugin.Helper {
    public static final ParameterizedTypeName ADDITIONAL_PROPERTIES_TYPE = ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class});

    @Override
    public TypeSpec.Builder classCreated(ObjectPluginContext objectPluginContext, ObjectTypeDeclaration obj, TypeSpec.Builder typeSpec, EventType eventType) {
        if (eventType != EventType.IMPLEMENTATION && obj.additionalProperties().booleanValue()) {
            typeSpec.addMethod(MethodSpec.methodBuilder((String)"getAdditionalProperties").returns((TypeName)ADDITIONAL_PROPERTIES_TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(JsonAnyGetter.class).build());
            typeSpec.addMethod(MethodSpec.methodBuilder((String)"setAdditionalProperties").returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(String.class), (String)"key", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Object.class), (String)"value", (Modifier[])new Modifier[0]).build()).addAnnotation(JsonAnySetter.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            return typeSpec;
        }
        typeSpec.addAnnotation(AnnotationSpec.builder(JsonInclude.class).addMember("value", "$T.$L", new Object[]{JsonInclude.Include.class, "NON_NULL"}).build());
        if (obj.discriminatorValue() != null) {
            typeSpec.addAnnotation(AnnotationSpec.builder(JsonTypeName.class).addMember("value", "$S", new Object[]{obj.discriminatorValue()}).build());
        }
        AnnotationSpec.Builder builder = AnnotationSpec.builder(JsonPropertyOrder.class);
        for (TypeDeclaration declaration : obj.properties()) {
            builder.addMember("value", "$S", new Object[]{declaration.name()});
        }
        typeSpec.addAnnotation(builder.build());
        if (obj.additionalProperties().booleanValue()) {
            typeSpec.addField(FieldSpec.builder((TypeName)ADDITIONAL_PROPERTIES_TYPE, (String)"additionalProperties", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(JsonIgnore.class).build()).initializer(CodeBlock.of((String)"new $T()", (Object[])new Object[]{ParameterizedTypeName.get(HashMap.class, (Type[])new Type[]{String.class, Object.class})})).build());
            typeSpec.addMethod(MethodSpec.methodBuilder((String)"getAdditionalProperties").returns((TypeName)ADDITIONAL_PROPERTIES_TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("return additionalProperties;\n", new Object[0]).addAnnotation(JsonAnyGetter.class).build());
            typeSpec.addMethod(MethodSpec.methodBuilder((String)"setAdditionalProperties").returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(String.class), (String)"key", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Object.class), (String)"value", (Modifier[])new Modifier[0]).build()).addAnnotation(JsonAnySetter.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().add("this.additionalProperties.put(key, value);\n", new Object[0]).build()).build());
        }
        return typeSpec;
    }

    @Override
    public FieldSpec.Builder fieldBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration declaration, FieldSpec.Builder fieldSpec, EventType eventType) {
        return fieldSpec.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{declaration.name()}).build());
    }

    @Override
    public MethodSpec.Builder getterBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration declaration, MethodSpec.Builder methodSpec, EventType eventType) {
        return methodSpec.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{declaration.name()}).build());
    }

    @Override
    public MethodSpec.Builder setterBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration declaration, MethodSpec.Builder methodSpec, EventType eventType) {
        return methodSpec.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{declaration.name()}).build());
    }
}

