/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.object;

import com.google.common.base.Optional;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EcmaPattern;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContext;
import org.raml.ramltopojo.GenerationException;
import org.raml.ramltopojo.Names;
import org.raml.ramltopojo.TypeDeclarationType;
import org.raml.ramltopojo.TypeHandler;
import org.raml.ramltopojo.Utils;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectPluginContextImpl;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class ObjectTypeHandler
implements TypeHandler {
    private final String name;
    private final ObjectTypeDeclaration objectTypeDeclaration;

    public ObjectTypeHandler(String name, ObjectTypeDeclaration objectTypeDeclaration) {
        this.name = name;
        this.objectTypeDeclaration = objectTypeDeclaration;
    }

    @Override
    public ClassName javaClassName(GenerationContext generationContext, EventType type) {
        ObjectPluginContextImpl context = new ObjectPluginContextImpl(generationContext, null);
        ObjectTypeHandlerPlugin plugin = generationContext.pluginsForObjects(Utils.allParents((TypeDeclaration)this.objectTypeDeclaration, new ArrayList<TypeDeclaration>()).toArray(new TypeDeclaration[0]));
        ClassName className = type == EventType.IMPLEMENTATION ? generationContext.buildDefaultClassName(Names.typeName(this.name, "Impl"), EventType.IMPLEMENTATION) : generationContext.buildDefaultClassName(Names.typeName(this.name), EventType.INTERFACE);
        return plugin.className(context, this.objectTypeDeclaration, className, type);
    }

    @Override
    public TypeName javaClassReference(GenerationContext generationContext, EventType type) {
        return this.javaClassName(generationContext, type);
    }

    @Override
    public Optional<CreationResult> create(GenerationContext generationContext, CreationResult result) {
        ObjectPluginContextImpl context = new ObjectPluginContextImpl(generationContext, result);
        TypeSpec interfaceSpec = this.createInterface(context, result, generationContext);
        TypeSpec implementationSpec = this.createImplementation(context, result, generationContext);
        if (interfaceSpec == null) {
            return Optional.absent();
        }
        return Optional.of((Object)result.withInterface(interfaceSpec).withImplementation(implementationSpec));
    }

    private TypeSpec createImplementation(ObjectPluginContext objectPluginContext, CreationResult result, GenerationContext generationContext) {
        ClassName className = result.getJavaName(EventType.IMPLEMENTATION);
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((ClassName)className).addSuperinterface((TypeName)result.getJavaName(EventType.INTERFACE)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        Optional discriminator = Optional.fromNullable((Object)this.objectTypeDeclaration.discriminator());
        for (TypeDeclaration propertyDeclaration : this.objectTypeDeclaration.properties()) {
            TypeName tn;
            if (EcmaPattern.isSlashedPattern(propertyDeclaration.name())) continue;
            if (TypeDeclarationType.isNewInlineType(propertyDeclaration)) {
                CreationResult cr = result.internalType(propertyDeclaration.name());
                tn = cr.getJavaName(EventType.INTERFACE);
            } else {
                tn = this.findType(propertyDeclaration.type(), propertyDeclaration, generationContext, EventType.INTERFACE);
            }
            FieldSpec.Builder field = FieldSpec.builder((TypeName)tn, (String)Names.variableName(propertyDeclaration.name()), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
            if (propertyDeclaration.name().equals(discriminator.orNull())) {
                String discriminatorValue = (String)Optional.fromNullable((Object)this.objectTypeDeclaration.discriminatorValue()).or((Object)this.objectTypeDeclaration.name());
                field.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer(CodeBlock.builder().add("$S", new Object[]{discriminatorValue}).build());
            }
            if ((field = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).fieldBuilt(objectPluginContext, propertyDeclaration, field, EventType.IMPLEMENTATION)) != null) {
                typeSpec.addField(field.build());
            }
            MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)Names.methodName("get", propertyDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().addStatement("return this." + Names.variableName(propertyDeclaration.name()), new Object[0]).build()).returns(tn);
            getMethod = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).getterBuilt(objectPluginContext, propertyDeclaration, getMethod, EventType.IMPLEMENTATION);
            if (getMethod != null) {
                typeSpec.addMethod(getMethod.build());
            }
            if (propertyDeclaration.name().equals(discriminator.orNull())) continue;
            MethodSpec.Builder setMethod = MethodSpec.methodBuilder((String)Names.methodName("set", propertyDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().addStatement("this." + Names.variableName(propertyDeclaration.name()) + " = " + Names.variableName(propertyDeclaration.name()), new Object[0]).build()).addParameter(tn, Names.variableName(propertyDeclaration.name()), new Modifier[0]);
            setMethod = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).setterBuilt(objectPluginContext, propertyDeclaration, setMethod, EventType.IMPLEMENTATION);
            if (setMethod == null) continue;
            typeSpec.addMethod(setMethod.build());
        }
        typeSpec = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration}).classCreated(objectPluginContext, this.objectTypeDeclaration, typeSpec, EventType.IMPLEMENTATION);
        if (typeSpec == null) {
            return null;
        }
        return typeSpec.build();
    }

    private TypeSpec createInterface(ObjectPluginContext objectPluginContext, CreationResult result, GenerationContext generationContext) {
        ClassName interf = result.getJavaName(EventType.INTERFACE);
        TypeSpec.Builder typeSpec = TypeSpec.interfaceBuilder((ClassName)interf).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        typeSpec = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration}).classCreated(objectPluginContext, this.objectTypeDeclaration, typeSpec, EventType.INTERFACE);
        if (typeSpec == null) {
            return null;
        }
        Optional discriminator = Optional.fromNullable((Object)this.objectTypeDeclaration.discriminator());
        for (TypeDeclaration typeDeclaration : this.objectTypeDeclaration.parentTypes()) {
            if (typeDeclaration instanceof ObjectTypeDeclaration) {
                if (typeDeclaration.name().equals("object")) continue;
                TypeName inherits = this.findType(typeDeclaration.name(), typeDeclaration, generationContext, EventType.INTERFACE);
                typeSpec.addSuperinterface(inherits);
                continue;
            }
            throw new GenerationException("ramltopojo does not support inheriting from " + Utils.declarationType(typeDeclaration) + " name: " + typeDeclaration.name() + " and " + typeDeclaration.type());
        }
        for (TypeDeclaration propertyDeclaration : this.objectTypeDeclaration.properties()) {
            if (EcmaPattern.isSlashedPattern(propertyDeclaration.name())) continue;
            TypeName tn = null;
            if (TypeDeclarationType.isNewInlineType(propertyDeclaration)) {
                Optional<CreationResult> cr = TypeDeclarationType.createInlineType(interf, result.getJavaName(EventType.IMPLEMENTATION), Names.typeName(propertyDeclaration.name(), "type"), propertyDeclaration, generationContext);
                if (cr.isPresent()) {
                    result.withInternalType(propertyDeclaration.name(), (CreationResult)cr.get());
                    tn = ((CreationResult)cr.get()).getJavaName(EventType.INTERFACE);
                }
            } else {
                tn = this.findType(propertyDeclaration.type(), propertyDeclaration, generationContext, EventType.INTERFACE);
            }
            if (tn == null) continue;
            MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)Names.methodName("get", propertyDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(tn);
            getMethod = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).getterBuilt(objectPluginContext, propertyDeclaration, getMethod, EventType.INTERFACE);
            if (getMethod != null) {
                typeSpec.addMethod(getMethod.build());
                if (propertyDeclaration.name().equals(discriminator.orNull())) continue;
            }
            MethodSpec.Builder setMethod = MethodSpec.methodBuilder((String)Names.methodName("set", propertyDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(tn, Names.variableName(propertyDeclaration.name()), new Modifier[0]);
            setMethod = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).setterBuilt(objectPluginContext, propertyDeclaration, setMethod, EventType.INTERFACE);
            if (setMethod == null) continue;
            typeSpec.addMethod(setMethod.build());
        }
        return typeSpec.build();
    }

    private TypeName findType(String typeName, TypeDeclaration type, GenerationContext generationContext, EventType eventType) {
        return TypeDeclarationType.calculateTypeName(typeName, type, generationContext, eventType);
    }
}

